/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.debug;

import net.sf.jqql.Util;
import net.sf.jqql.debug.IDebugObject;

public abstract class AbstractDebugObject
implements IDebugObject {
    protected String name;
    protected byte[] bytes;
    protected String hexString;
    protected boolean incoming;
    protected String bodyHexString;
    protected byte[] bodyBytes;

    public AbstractDebugObject(String string, byte[] byArray) {
        this(string, byArray, false);
    }

    public AbstractDebugObject(String string, byte[] byArray, boolean bl) {
        this.name = string;
        this.bytes = byArray;
        this.incoming = bl;
        this.bodyBytes = this.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getHexString() {
        if (this.hexString == null) {
            this.hexString = this.bytes != null ? Util.convertByteToHexString(this.bytes) : "";
        }
        return this.hexString;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public int getLength() {
        if (this.bytes == null) {
            return 0;
        }
        return this.bytes.length;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public String getBodyHexString() {
        if (this.bodyHexString == null) {
            this.bodyHexString = Util.convertByteToHexString(this.bodyBytes);
        }
        return this.bodyHexString;
    }
}

