/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MapConfigAdapter
implements DataSerializable {
    private MapConfig config;

    public MapConfigAdapter() {
    }

    public MapConfigAdapter(MapConfig mapConfig) {
        this.config = mapConfig;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.config = new MapConfig();
        this.config.setName(in.readUTF());
        this.config.setInMemoryFormat(InMemoryFormat.valueOf(in.readUTF()));
        this.config.setBackupCount(in.readInt());
        this.config.setAsyncBackupCount(in.readInt());
        this.config.setEvictionPercentage(in.readInt());
        this.config.setTimeToLiveSeconds(in.readInt());
        this.config.setMaxIdleSeconds(in.readInt());
        this.config.setMaxSizeConfig(new MaxSizeConfig().setSize(in.readInt()).setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf(in.readUTF())));
        this.config.setReadBackupData(in.readBoolean());
        this.config.setEvictionPolicy(MapConfig.EvictionPolicy.valueOf(in.readUTF()));
        this.config.setMergePolicy(in.readUTF());
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.config.getName());
        out.writeUTF(this.config.getInMemoryFormat().toString());
        out.writeInt(this.config.getBackupCount());
        out.writeInt(this.config.getAsyncBackupCount());
        out.writeInt(this.config.getEvictionPercentage());
        out.writeInt(this.config.getTimeToLiveSeconds());
        out.writeInt(this.config.getMaxIdleSeconds());
        out.writeInt(this.config.getMaxSizeConfig().getSize());
        out.writeUTF(this.config.getMaxSizeConfig().getMaxSizePolicy().toString());
        out.writeBoolean(this.config.isReadBackupData());
        out.writeUTF(this.config.getEvictionPolicy().name());
        out.writeUTF(this.config.getMergePolicy());
    }

    public MapConfig getMapConfig() {
        return this.config;
    }
}

