/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.Iterator;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class PacketError {
    private static DocumentFactory docFactory = DocumentFactory.getInstance();
    private Element element;

    public PacketError(Condition condition) {
        this.element = docFactory.createElement("error");
        this.setCondition(condition);
        this.setType(condition.getDefaultType());
    }

    public PacketError(Condition condition, Type type) {
        this.element = docFactory.createElement("error");
        this.setCondition(condition);
        this.setType(type);
    }

    public PacketError(Type type, Condition condition, String string) {
        this.element = docFactory.createElement("error");
        this.setType(type);
        this.setCondition(condition);
        this.setText(string);
    }

    public PacketError(Element element) {
        this.element = element;
    }

    public Type getType() {
        String string = this.element.attributeValue("type");
        if (string != null) {
            return Type.fromXMPP(string);
        }
        return null;
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toXMPP());
    }

    public Condition getCondition() {
        Object object = this.element.elementIterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (!element.getNamespaceURI().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || element.getName().equals("text")) continue;
            return Condition.fromXMPP(element.getName());
        }
        object = this.element.attributeValue("code");
        if (object != null) {
            try {
                return Condition.fromLegacyCode(Integer.parseInt((String)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCondition(Condition condition) {
        if (condition == null) {
            throw new NullPointerException("Condition cannot be null");
        }
        this.element.addAttribute("code", Integer.toString(condition.getLegacyCode()));
        Element element = null;
        Iterator iterator = this.element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!element2.getNamespaceURI().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || element2.getName().equals("text")) continue;
            element = element2;
        }
        if (element != null) {
            this.element.remove(element);
        }
        element = docFactory.createElement(condition.toXMPP(), "urn:ietf:params:xml:ns:xmpp-stanzas");
        this.element.add(element);
    }

    public String getText() {
        return this.element.elementText("text");
    }

    public void setText(String string) {
        Element element = this.element.element("text");
        if (string == null) {
            if (element != null) {
                this.element.remove(element);
            }
            return;
        }
        if (element == null) {
            element = docFactory.createElement("text", "urn:ietf:params:xml:ns:xmpp-stanzas");
            this.element.add(element);
        }
        element.setText(string);
    }

    public Element getElement() {
        return this.element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        cancel("cancel"),
        continue_processing("continue"),
        modify("modify"),
        auth("auth"),
        wait("wait");

        private String value;

        public static Type fromXMPP(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            string = string.toLowerCase();
            if (cancel.toXMPP().equals(string)) {
                return cancel;
            }
            if (continue_processing.toXMPP().equals(string)) {
                return continue_processing;
            }
            if (modify.toXMPP().equals(string)) {
                return modify;
            }
            if (auth.toXMPP().equals(string)) {
                return auth;
            }
            if (wait.toXMPP().equals(string)) {
                return wait;
            }
            throw new IllegalArgumentException("Type invalid:" + string);
        }

        private Type(String string2) {
            this.value = string2;
        }

        public String toXMPP() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Condition {
        bad_request("bad-request", Type.modify, 400),
        conflict("conflict", Type.cancel, 409),
        feature_not_implemented("feature-not-implemented", Type.cancel, 501),
        forbidden("forbidden", Type.auth, 403),
        gone("gone", Type.modify, 302),
        internal_server_error("internal-server-error", Type.wait, 500),
        item_not_found("item-not-found", Type.cancel, 404),
        jid_malformed("jid-malformed", Type.modify, 400),
        not_acceptable("not-acceptable", Type.modify, 406),
        not_allowed("not-allowed", Type.cancel, 405),
        not_authorized("not-authorized", Type.auth, 401),
        payment_required("payment-required", Type.auth, 402),
        recipient_unavailable("recipient-unavailable", Type.wait, 404),
        redirect("redirect", Type.modify, 302),
        registration_required("registration-required", Type.auth, 407),
        remote_server_not_found("remote-server-not-found", Type.cancel, 404),
        remote_server_timeout("remote-server-timeout", Type.wait, 504),
        resource_constraint("resource-constraint", Type.wait, 500),
        service_unavailable("service-unavailable", Type.cancel, 503),
        subscription_required("subscription-required", Type.auth, 407),
        undefined_condition("undefined-condition", Type.wait, 500),
        unexpected_condition("unexpected-condition", Type.wait, 400);

        private String value;
        private int code;
        private Type defaultType;

        public static Condition fromXMPP(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            string = string.toLowerCase();
            if (bad_request.toXMPP().equals(string)) {
                return bad_request;
            }
            if (conflict.toXMPP().equals(string)) {
                return conflict;
            }
            if (feature_not_implemented.toXMPP().equals(string)) {
                return feature_not_implemented;
            }
            if (forbidden.toXMPP().equals(string)) {
                return forbidden;
            }
            if (gone.toXMPP().equals(string)) {
                return gone;
            }
            if (internal_server_error.toXMPP().equals(string)) {
                return internal_server_error;
            }
            if (item_not_found.toXMPP().equals(string)) {
                return item_not_found;
            }
            if (jid_malformed.toXMPP().equals(string)) {
                return jid_malformed;
            }
            if (not_acceptable.toXMPP().equals(string)) {
                return not_acceptable;
            }
            if (not_allowed.toXMPP().equals(string)) {
                return not_allowed;
            }
            if (not_authorized.toXMPP().equals(string)) {
                return not_authorized;
            }
            if (payment_required.toXMPP().equals(string)) {
                return payment_required;
            }
            if (recipient_unavailable.toXMPP().equals(string)) {
                return recipient_unavailable;
            }
            if (redirect.toXMPP().equals(string)) {
                return redirect;
            }
            if (registration_required.toXMPP().equals(string)) {
                return registration_required;
            }
            if (remote_server_not_found.toXMPP().equals(string)) {
                return remote_server_not_found;
            }
            if (remote_server_timeout.toXMPP().equals(string)) {
                return remote_server_timeout;
            }
            if (resource_constraint.toXMPP().equals(string)) {
                return resource_constraint;
            }
            if (service_unavailable.toXMPP().equals(string)) {
                return service_unavailable;
            }
            if (subscription_required.toXMPP().equals(string)) {
                return subscription_required;
            }
            if (undefined_condition.toXMPP().equals(string)) {
                return undefined_condition;
            }
            if (unexpected_condition.toXMPP().equals(string)) {
                return unexpected_condition;
            }
            throw new IllegalArgumentException("Condition invalid:" + string);
        }

        public static Condition fromLegacyCode(int n) {
            if (bad_request.getLegacyCode() == n) {
                return bad_request;
            }
            if (conflict.getLegacyCode() == n) {
                return conflict;
            }
            if (feature_not_implemented.getLegacyCode() == n) {
                return feature_not_implemented;
            }
            if (forbidden.getLegacyCode() == n) {
                return forbidden;
            }
            if (gone.getLegacyCode() == n) {
                return gone;
            }
            if (internal_server_error.getLegacyCode() == n) {
                return internal_server_error;
            }
            if (item_not_found.getLegacyCode() == n) {
                return item_not_found;
            }
            if (jid_malformed.getLegacyCode() == n) {
                return jid_malformed;
            }
            if (not_acceptable.getLegacyCode() == n) {
                return not_acceptable;
            }
            if (not_allowed.getLegacyCode() == n) {
                return not_allowed;
            }
            if (not_authorized.getLegacyCode() == n) {
                return not_authorized;
            }
            if (payment_required.getLegacyCode() == n) {
                return payment_required;
            }
            if (recipient_unavailable.getLegacyCode() == n) {
                return recipient_unavailable;
            }
            if (redirect.getLegacyCode() == n) {
                return redirect;
            }
            if (registration_required.getLegacyCode() == n) {
                return registration_required;
            }
            if (remote_server_not_found.getLegacyCode() == n) {
                return remote_server_not_found;
            }
            if (remote_server_timeout.getLegacyCode() == n) {
                return remote_server_timeout;
            }
            if (resource_constraint.getLegacyCode() == n) {
                return resource_constraint;
            }
            if (service_unavailable.getLegacyCode() == n) {
                return service_unavailable;
            }
            if (subscription_required.getLegacyCode() == n) {
                return subscription_required;
            }
            if (undefined_condition.getLegacyCode() == n) {
                return undefined_condition;
            }
            if (unexpected_condition.getLegacyCode() == n) {
                return unexpected_condition;
            }
            throw new IllegalArgumentException("Code invalid:" + n);
        }

        private Condition(String string2, Type type, int n2) {
            this.value = string2;
            this.defaultType = type;
            this.code = n2;
        }

        public Type getDefaultType() {
            return this.defaultType;
        }

        public int getLegacyCode() {
            return this.code;
        }

        public String toXMPP() {
            return this.value;
        }
    }
}

