/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    MessageDigest createDigest(int n) throws GeneralSecurityException, PGPException {
        MessageDigest messageDigest = this.helper.createDigest(PGPUtil.getDigestName(n));
        return messageDigest;
    }

    KeyFactory createKeyFactory(String string) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(string);
    }

    PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(n));
            final Cipher cipher = this.createStreamCipher(n, bl);
            byte[] byArray2 = new byte[cipher.getBlockSize()];
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    return new CipherInputStream(inputStream, cipher);
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    Cipher createStreamCipher(int n, boolean bl) throws PGPException {
        String string = bl ? "CFB" : "OpenPGPCFB";
        String string2 = PGPUtil.getSymmetricCipherName(n) + "/" + string + "/NoPadding";
        return this.createCipher(string2);
    }

    Cipher createCipher(String string) throws PGPException {
        try {
            return this.helper.createCipher(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    Cipher createPublicKeyCipher(int n) throws PGPException {
        switch (n) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + n);
    }

    Cipher createKeyWrapper(int n) throws PGPException {
        try {
            switch (n) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private Signature createSignature(String string) throws PGPException {
        try {
            return this.helper.createSignature(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public Signature createSignature(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(n2) + "with" + string);
    }
}

