/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class SortedIndexStore
extends BaseIndexStore {
    private final ConcurrentMap<Data, QueryableEntry> recordsWithNullValue = new ConcurrentHashMap<Data, QueryableEntry>();
    private final ConcurrentSkipListMap<Comparable, ConcurrentMap<Data, QueryableEntry>> recordMap = new ConcurrentSkipListMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newIndex(Comparable newValue, QueryableEntry record) {
        this.takeWriteLock();
        try {
            if (newValue instanceof IndexImpl.NullObject) {
                this.recordsWithNullValue.put(record.getIndexKey(), record);
            } else {
                ConcurrentMap<Data, QueryableEntry> records = this.recordMap.get(newValue);
                if (records == null) {
                    records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
                    this.recordMap.put(newValue, records);
                }
                records.put(record.getIndexKey(), record);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndex(Comparable oldValue, Comparable newValue, QueryableEntry entry) {
        this.takeWriteLock();
        try {
            this.removeIndex(oldValue, entry.getIndexKey());
            this.newIndex(newValue, entry);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Comparable oldValue, Data indexKey) {
        this.takeWriteLock();
        try {
            if (oldValue instanceof IndexImpl.NullObject) {
                this.recordsWithNullValue.remove(indexKey);
            } else {
                ConcurrentMap<Data, QueryableEntry> records = this.recordMap.get(oldValue);
                if (records != null) {
                    records.remove(indexKey);
                    if (records.size() == 0) {
                        this.recordMap.remove(oldValue);
                    }
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordsWithNullValue.clear();
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSubRecordsBetween(MultiResultSet results, Comparable from, Comparable to) {
        this.takeReadLock();
        try {
            NavigableMap subMap = this.recordMap.subMap((Object)from, true, (Object)to, true);
            for (ConcurrentMap value : subMap.values()) {
                results.addResultSet(value);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSubRecords(MultiResultSet results, ComparisonType comparisonType, Comparable searchedValue) {
        this.takeReadLock();
        try {
            NavigableMap subMap;
            switch (comparisonType) {
                case LESSER: {
                    subMap = this.recordMap.headMap((Object)searchedValue, false);
                    break;
                }
                case LESSER_EQUAL: {
                    subMap = this.recordMap.headMap((Object)searchedValue, true);
                    break;
                }
                case GREATER: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, false);
                    break;
                }
                case GREATER_EQUAL: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, true);
                    break;
                }
                case NOT_EQUAL: {
                    for (Map.Entry<Comparable, ConcurrentMap<Data, QueryableEntry>> entry : this.recordMap.entrySet()) {
                        if (searchedValue.equals(entry.getKey())) continue;
                        results.addResultSet(entry.getValue());
                    }
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized comparisonType: " + (Object)((Object)comparisonType));
                }
            }
            for (ConcurrentMap value : subMap.values()) {
                results.addResultSet(value);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                ConcurrentMap<Data, QueryableEntry> concurrentMap = this.recordsWithNullValue;
                return concurrentMap;
            }
            ConcurrentMap<Data, QueryableEntry> concurrentMap = this.recordMap.get(value);
            return concurrentMap;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                SingleResultSet singleResultSet = new SingleResultSet(this.recordsWithNullValue);
                return singleResultSet;
            }
            SingleResultSet singleResultSet = new SingleResultSet(this.recordMap.get(value));
            return singleResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRecords(MultiResultSet results, Set<Comparable> values) {
        this.takeReadLock();
        try {
            for (Comparable value : values) {
                ConcurrentMap<Data, QueryableEntry> records = value instanceof IndexImpl.NullObject ? this.recordsWithNullValue : this.recordMap.get(value);
                if (records == null) continue;
                results.addResultSet(records);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String toString() {
        return "SortedIndexStore{recordMap=" + this.recordMap.size() + '}';
    }
}

