/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.impl.FileProcessor;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultProcessor
implements Processor {
    private boolean nullPathInfoWorkaround = false;
    private Processor index;
    private Processor test;
    private Processor iface;
    private Processor exec;
    private FileProcessor file;
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.impl.DefaultProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        String servletPath = req.getServletPath();
        if (this.nullPathInfoWorkaround && pathInfo == null) {
            pathInfo = req.getServletPath();
            servletPath = "/";
            log.debug("Default servlet suspected. pathInfo=" + pathInfo + "; contextPath=" + req.getContextPath() + "; servletPath=" + servletPath);
        }
        if (pathInfo == null || pathInfo.length() == 0 || pathInfo.equals("/")) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + servletPath + "/index.html");
        } else if (pathInfo.startsWith("/index.html")) {
            this.index.handle(req, resp);
        } else if (pathInfo.startsWith("/test/")) {
            this.test.handle(req, resp);
        } else if (pathInfo.startsWith("/interface/")) {
            this.iface.handle(req, resp);
        } else if (pathInfo.startsWith("/exec")) {
            this.exec.handle(req, resp);
        } else if (pathInfo.equalsIgnoreCase("/engine.js")) {
            this.file.doFile(req, resp, "/engine.js", "text/javascript");
        } else if (pathInfo.equalsIgnoreCase("/util.js")) {
            this.file.doFile(req, resp, "/util.js", "text/javascript");
        } else if (pathInfo.equalsIgnoreCase("/deprecated.js")) {
            this.file.doFile(req, resp, "/deprecated.js", "text/javascript");
        } else {
            log.warn("Page not found (" + pathInfo + "). In debug/test mode try viewing /[WEB-APP]/dwr/");
            resp.sendError(404);
        }
    }

    public void setExec(Processor exec) {
        this.exec = exec;
    }

    public void setFile(FileProcessor file) {
        this.file = file;
    }

    public void setInterface(Processor iface) {
        this.iface = iface;
    }

    public void setIndex(Processor index) {
        this.index = index;
    }

    public void setTest(Processor test) {
        this.test = test;
    }

    public void setNullPathInfoWorkaround(String nullPathInfoWorkaround) {
        this.nullPathInfoWorkaround = Boolean.valueOf(nullPathInfoWorkaround);
    }
}

