/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.helpers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import weblogic.xml.babel.helpers.Sorter;

public class Outputter
implements ContentHandler,
DTDHandler {
    private boolean isValidating;
    private String compareURI;
    private StringBuffer utf16 = new StringBuffer();
    private ByteArrayOutputStream utf8 = new ByteArrayOutputStream();
    private Sorter notations;
    private Sorter entities;

    public Outputter(boolean bl, String string) {
        this.isValidating = bl;
        this.compareURI = string;
    }

    public void getOutputXML(String string) throws IOException, FileNotFoundException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.utf8.writeTo(fileOutputStream);
        this.utf8.reset();
    }

    public String getDiagnostic(boolean bl) {
        byte[] byArray;
        byte[] byArray2 = this.utf8.toByteArray();
        String string = null;
        try {
            int n;
            URL uRL = new URL(this.compareURI);
            InputStream inputStream = uRL.openStream();
            byte[] byArray3 = new byte[1024];
            if (bl) {
                File file = File.createTempFile("Outputter", "xml");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.utf8.writeTo(fileOutputStream);
                System.out.println("UTF8:" + this.utf8 + ":END");
            }
            this.utf8.reset();
            while ((n = inputStream.read(byArray3)) >= 0) {
                this.utf8.write(byArray3, 0, n);
            }
            inputStream.close();
            byArray = this.utf8.toByteArray();
            if (bl) {
                System.out.println("CANO:" + byArray + ":END");
            }
        }
        catch (Exception exception) {
            return "[I/O problem checking output: " + exception.getMessage() + "]";
        }
        int n = 0;
        while (string == null && n < byArray.length) {
            if (n >= byArray2.length) {
                string = "Output ends at byte " + n + " but should continue to byte " + byArray.length;
            } else if (byArray2[n] != byArray[n]) {
                string = "Output byte " + n + " has the wrong value; actual 0x" + Integer.toHexString(0xFF & byArray2[n]) + " should instead be 0x" + Integer.toHexString(0xFF & byArray[n]);
            }
            ++n;
        }
        if (string == null && byArray2.length != byArray.length) {
            string = "Too much output; length is " + byArray2.length + " but should only be " + byArray.length;
        }
        return string;
    }

    private void writeUTF8(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n + n3];
            if (c < '\u0080') {
                this.utf8.write(c);
            } else {
                switch (c & 0xF800) {
                    case 0: {
                        this.utf8.write(c >> 6 & 0x1F | 0xC0);
                        this.utf8.write(c & 0x3F | 0x80);
                        break;
                    }
                    case 55296: {
                        if (n3 + 1 < n2) {
                            char c2 = cArray[n + n3 + 1];
                            if ((c & 0xFC00) == 55296 && (c2 & 0xFC00) == 56320) {
                                ++n3;
                                int n4 = (c & 0x3FF) << 10 | c2 & 0x3FF;
                                this.utf8.write((n4 += 65536) >> 18 & 7 | 0xF0);
                                this.utf8.write(n4 >> 12 & 0x3F | 0x80);
                                this.utf8.write(n4 >> 6 & 0x3F | 0x80);
                                this.utf8.write(n4 & 0x3F | 0x80);
                                break;
                            }
                        }
                    }
                    default: {
                        this.utf8.write(c >> 12 & 0xF | 0xE0);
                        this.utf8.write(c >> 6 & 0x3F | 0x80);
                        this.utf8.write(c & 0x3F | 0x80);
                    }
                }
            }
            ++n3;
        }
    }

    private void escapeUTF16(char c) {
        switch (c) {
            case '&': {
                this.utf16.append("&amp;");
                break;
            }
            case '<': {
                this.utf16.append("&lt;");
                break;
            }
            case '>': {
                this.utf16.append("&gt;");
                break;
            }
            case '\"': {
                this.utf16.append("&quot;");
                break;
            }
            case '\t': {
                this.utf16.append("&#9;");
                break;
            }
            case '\n': {
                this.utf16.append("&#10;");
                break;
            }
            case '\r': {
                this.utf16.append("&#13;");
                break;
            }
            default: {
                this.utf16.append(c);
            }
        }
    }

    public void escapeUTF16(char[] cArray, int n, int n2) {
        while (n2-- > 0) {
            this.escapeUTF16(cArray[n++]);
        }
    }

    private void escapeUTF16(String string) {
        char[] cArray = string.toCharArray();
        this.escapeUTF16(cArray, 0, cArray.length);
    }

    private void writeUTF16(String string) {
        this.utf16.append(string);
    }

    private void flushUTF16() throws SAXException {
        try {
            char[] cArray = this.utf16.toString().toCharArray();
            this.utf16.setLength(0);
            this.writeUTF8(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.writeUTF16("<?");
        this.writeUTF16(string);
        this.writeUTF16(" ");
        this.writeUTF16(string2);
        this.writeUTF16("?>");
        this.flushUTF16();
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        String string4 = "<!NOTATION " + string;
        if (string2 != null) {
            string4 = string4 + " PUBLIC '" + string2;
            if (string3 != null) {
                string4 = string4 + "' '" + string3;
            }
        } else {
            string4 = string4 + " SYSTEM '" + string3;
        }
        string4 = string4 + "'>\n";
        if (this.notations == null) {
            this.notations = new Sorter();
        }
        this.notations.put(string, string4);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (!this.isValidating) {
            return;
        }
        String string5 = "<!ENTITY " + string;
        string5 = string2 != null ? string5 + "PUBLIC '" + string2 + "' '" : string5 + "SYSTEM '";
        string5 = string5 + string3 + "' NDATA " + string4 + ">\n";
        if (this.entities == null) {
            this.entities = new Sorter();
        }
        this.entities.put(string, string5);
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        if (this.notations != null) {
            this.writeUTF16("<!DOCTYPE ");
            this.writeUTF16(string3);
            this.writeUTF16(" [\n");
            this.flushUTF16();
            Enumeration enumeration = this.notations.elements();
            while (enumeration.hasMoreElements()) {
                this.writeUTF16((String)enumeration.nextElement());
            }
            this.flushUTF16();
            if (this.entities != null) {
                object = this.entities.elements();
                while (object.hasMoreElements()) {
                    this.writeUTF16((String)object.nextElement());
                }
            }
            this.writeUTF16("]>\n");
            this.flushUTF16();
            this.notations = null;
            this.entities = null;
        }
        this.writeUTF16("<");
        this.writeUTF16(string3);
        if (attributes != null && attributes.getLength() != 0) {
            Object object2;
            int n = attributes.getLength();
            object = new int[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = n2;
                ++n2;
            }
            int n3 = 1;
            while (n3 < n) {
                object2 = object[n3];
                String string4 = attributes.getQName((int)object2);
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    if (string4.compareTo(attributes.getQName((int)object[n4])) >= 0) break;
                    object[n4 + 1] = object[n4];
                    --n4;
                }
                object[n4 + 1] = object2;
                ++n3;
            }
            object2 = 0;
            while (object2 < n) {
                this.writeUTF16(" ");
                this.writeUTF16(attributes.getQName((int)object[object2]));
                this.writeUTF16("=\"");
                this.escapeUTF16(attributes.getValue((int)object[object2]));
                this.writeUTF16("\"");
                this.flushUTF16();
                ++object2;
            }
        }
        this.writeUTF16(">");
        this.flushUTF16();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.writeUTF16("</");
        this.writeUTF16(string3);
        this.writeUTF16(">");
        this.flushUTF16();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.escapeUTF16(cArray, n, n2);
        this.flushUTF16();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.isValidating) {
            this.characters(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
    }
}

