/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jirecon;

import java.util.Collection;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

public class JireconIq
extends IQ {
    public static final String NAMESPACE = "http://jitsi.org/protocol/jirecon";
    public static final String ELEMENT_NAME = "recording";
    public static final String ACTION_ATTR_NAME = "action";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String MUCJID_ATTR_NAME = "mucjid";
    public static final String OUTPUT_ATTR_NAME = "dst";
    public static final String RID_ATTR_NAME = "rid";
    private Action action = Action.UNDEFINED;
    private String mucJid;
    private String output;
    private String rid;
    private Status status = Status.UNDEFINED;

    public String getChildElementXML() {
        StringBuilder xml = new StringBuilder();
        xml.append('<').append(ELEMENT_NAME);
        xml.append(" xmlns='").append(NAMESPACE).append("' ");
        this.printStringAttribute(xml, RID_ATTR_NAME, this.rid);
        if (this.action != Action.UNDEFINED) {
            this.printStringAttribute(xml, ACTION_ATTR_NAME, this.action.toString());
        }
        if (this.status != Status.UNDEFINED) {
            this.printStringAttribute(xml, STATUS_ATTR_NAME, this.status.toString());
        }
        this.printStringAttribute(xml, MUCJID_ATTR_NAME, this.mucJid);
        this.printStringAttribute(xml, OUTPUT_ATTR_NAME, this.output);
        Collection extensions = this.getExtensions();
        if (extensions.size() > 0) {
            xml.append(">");
            for (PacketExtension extension : extensions) {
                xml.append(extension.toXML());
            }
            xml.append("</").append(ELEMENT_NAME).append(">");
        } else {
            xml.append("/>");
        }
        return xml.toString();
    }

    private void printStringAttribute(StringBuilder xml, String attrName, String attr) {
        if (!StringUtils.isNullOrEmpty((String)attr)) {
            xml.append(attrName).append("='").append(attr).append("' ");
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setMucJid(String mucJid) {
        this.mucJid = mucJid;
    }

    public String getMucJid() {
        return this.mucJid;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public String getRid() {
        return this.rid;
    }

    public static enum Status {
        INITIATING("initiating"),
        STARTED("started"),
        STOPPING("stopping"),
        STOPPED("stopped"),
        ABORTED("aborted"),
        UNDEFINED("undefined");

        private String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Status parse(String status) {
            if (StringUtils.isNullOrEmpty((String)status)) {
                return UNDEFINED;
            }
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }

    public static enum Action {
        START("start"),
        STOP("stop"),
        INFO("info"),
        UNDEFINED("undefined");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Action parse(String action) {
            if (StringUtils.isNullOrEmpty((String)action)) {
                return UNDEFINED;
            }
            try {
                return Action.valueOf(action.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

