/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.impl.protocol.jabber.sasl.SASLDigestMD5Mechanism;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class LoginByPasswordStrategy
implements JabberLoginStrategy {
    private final AbstractProtocolProviderService protocolProvider;
    private final AccountID accountID;
    private String password;
    private String DISABLE_CUSTOM_DIGEST_MD5_ACCOUNT_PROP = "DISABLE_CUSTOM_DIGEST_MD5";
    private String DISABLE_CUSTOM_DIGEST_MD5_CONFIG_PROP = "net.java.sip.communicator.impl.protocol.jabber.DISABLE_CUSTOM_DIGEST_MD5";
    private static boolean saslMechanismsInitialized = false;
    private static Object modifySASLMechanisms = new Object();

    public LoginByPasswordStrategy(AbstractProtocolProviderService protocolProvider, AccountID accountID) {
        this.protocolProvider = protocolProvider;
        this.accountID = accountID;
    }

    @Override
    public UserCredentials prepareLogin(SecurityAuthority authority, int reasonCode) {
        return this.loadPassword(authority, reasonCode);
    }

    @Override
    public boolean loginPreparationSuccessful() {
        return this.password != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login(XMPPConnection connection, String userName, String resource) throws XMPPException {
        Object object = modifySASLMechanisms;
        synchronized (object) {
            boolean disableCustomDigestMD5PerAccount = this.accountID.getAccountPropertyBoolean((Object)this.DISABLE_CUSTOM_DIGEST_MD5_ACCOUNT_PROP, false);
            if (!saslMechanismsInitialized || disableCustomDigestMD5PerAccount) {
                boolean disableCustomDigestMD5;
                SASLAuthentication.supportSASLMechanism((String)"PLAIN", (int)0);
                boolean bl = disableCustomDigestMD5 = disableCustomDigestMD5PerAccount || JabberActivator.getConfigurationService().getBoolean(this.DISABLE_CUSTOM_DIGEST_MD5_CONFIG_PROP, false);
                if (!disableCustomDigestMD5) {
                    SASLAuthentication.unregisterSASLMechanism((String)"DIGEST-MD5");
                    SASLAuthentication.registerSASLMechanism((String)"DIGEST-MD5", SASLDigestMD5Mechanism.class);
                    SASLAuthentication.supportSASLMechanism((String)"DIGEST-MD5");
                }
                saslMechanismsInitialized = true;
            }
        }
        object = modifySASLMechanisms;
        synchronized (object) {
            connection.login(userName, this.password, resource);
        }
        return true;
    }

    @Override
    public boolean isTlsRequired() {
        return !this.accountID.getAccountPropertyBoolean((Object)"ALLOW_NON_SECURE", false);
    }

    @Override
    public SSLContext createSslContext(CertificateService cs, X509TrustManager trustManager) throws GeneralSecurityException {
        return cs.getSSLContext(trustManager);
    }

    private UserCredentials loadPassword(SecurityAuthority authority, int reasonCode) {
        UserCredentials cachedCredentials = null;
        this.password = JabberActivator.getProtocolProviderFactory().loadPassword(this.accountID);
        if (this.password == null) {
            UserCredentials credentials = new UserCredentials();
            credentials.setUserName(this.accountID.getUserID());
            credentials = authority.obtainCredentials(this.accountID.getDisplayName(), credentials, reasonCode);
            if (credentials == null) {
                this.protocolProvider.fireRegistrationStateChanged(this.protocolProvider.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No credentials provided");
                return null;
            }
            char[] pass = credentials.getPassword();
            if (pass == null) {
                this.protocolProvider.fireRegistrationStateChanged(this.protocolProvider.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No password entered");
                return null;
            }
            this.password = new String(pass);
            if (credentials.isPasswordPersistent()) {
                JabberActivator.getProtocolProviderFactory().storePassword(this.accountID, this.password);
            } else {
                cachedCredentials = credentials;
            }
        }
        return cachedCredentials;
    }
}

