/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.packetlogging;

import net.java.sip.communicator.impl.packetlogging.PacketLoggingServiceImpl;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PacketLoggingActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(PacketLoggingActivator.class);
    private static BundleContext bundleContext = null;
    private static PacketLoggingServiceImpl packetLoggingService = null;
    private static ConfigurationService configurationService = null;
    private static FileAccessService fileAccessService;
    static final String LOGGING_DIR_NAME = "log";

    public void start(BundleContext bundleContext) throws Exception {
        fileAccessService = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        if (fileAccessService != null) {
            PacketLoggingActivator.bundleContext = bundleContext;
            packetLoggingService = new PacketLoggingServiceImpl();
            packetLoggingService.start();
            bundleContext.registerService(PacketLoggingService.class.getName(), (Object)packetLoggingService, null);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Packet Logging Service ...[REGISTERED]");
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (packetLoggingService != null) {
            packetLoggingService.stop();
        }
        configurationService = null;
        fileAccessService = null;
        packetLoggingService = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Packet Logging Service ...[STOPPED]");
        }
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static FileAccessService getFileAccessService() {
        return fileAccessService;
    }
}

