/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class HazelcastServerCachingProvider
extends AbstractHazelcastCachingProvider {
    public static HazelcastServerCachingProvider createCachingProvider(HazelcastInstance hazelcastInstance) {
        HazelcastServerCachingProvider cachingProvider = new HazelcastServerCachingProvider();
        cachingProvider.hazelcastInstance = hazelcastInstance;
        return cachingProvider;
    }

    protected HazelcastServerCacheManager createHazelcastCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        HazelcastInstance instance;
        if (uri == null || uri.equals(this.getDefaultURI())) {
            if (this.hazelcastInstance == null) {
                try {
                    this.hazelcastInstance = this.instanceFromProperties(classLoader, properties, true);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            instance = this.hazelcastInstance;
        } else {
            try {
                instance = this.instanceFromProperties(classLoader, properties, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return new HazelcastServerCacheManager(this, instance, uri, classLoader, properties);
    }

    private HazelcastInstance instanceFromProperties(ClassLoader classLoader, Properties properties, boolean isDefault) throws URISyntaxException, IOException {
        String instanceName;
        ClassLoader theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HazelcastInstance instance = null;
        String location = properties.getProperty("hazelcast.config.location");
        if (location != null) {
            URL configURL;
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = new URI(System.getProperty(uri.getRawSchemeSpecificPart()));
            }
            if ("classpath".equals(scheme)) {
                configURL = theClassLoader.getResource(uri.getRawSchemeSpecificPart());
            } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
                configURL = uri.toURL();
            } else {
                throw new URISyntaxException(location, "Unsupported protocol in configuration location URL");
            }
            try {
                Config config = new XmlConfigBuilder(configURL).build();
                config.setClassLoader(theClassLoader);
                config.setInstanceName(configURL.toString());
                instance = HazelcastInstanceFactory.getOrCreateHazelcastInstance(config);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if ((instanceName = properties.getProperty("hazelcast.instance.name")) != null) {
            instance = Hazelcast.getHazelcastInstanceByName(instanceName);
        }
        if (isDefault) {
            Config config = new XmlConfigBuilder().build();
            if (config.getInstanceName() == null) {
                config.setInstanceName("JCacheSharedInstance");
            }
            instance = HazelcastInstanceFactory.getOrCreateHazelcastInstance(config);
        }
        return instance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HazelcastServerCachingProvider{");
        sb.append("hazelcastInstance=").append(this.hazelcastInstance);
        sb.append('}');
        return sb.toString();
    }
}

