/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.tlv.TlvTools;

public final class Tlv
implements Writable {
    private final int type;
    private ByteBlock data;
    private final int totalSize;
    private final Writable writer;

    public static Tlv getStringInstance(int n, String string) {
        return new Tlv(n, ByteBlock.wrap(BinaryTools.getAsciiBytes(string)));
    }

    public static Tlv getUShortInstance(int n, int n2) {
        return new Tlv(n, ByteBlock.wrap(BinaryTools.getUShort(n2)));
    }

    public static Tlv getUIntInstance(int n, long l) {
        return new Tlv(n, ByteBlock.wrap(BinaryTools.getUInt(l)));
    }

    public static boolean isValidTLV(ByteBlock byteBlock) {
        if (byteBlock.getLength() < 4) {
            return false;
        }
        int n = BinaryTools.getUShort(byteBlock, 2);
        return n <= byteBlock.getLength() - 4;
    }

    public Tlv(int n) {
        this(n, ByteBlock.EMPTY_BLOCK);
    }

    public Tlv(int n, Writable writable) {
        DefensiveTools.checkRange(n, "type", 0);
        DefensiveTools.checkNull(writable, "data");
        this.type = n;
        this.writer = writable;
        this.data = writable instanceof ByteBlock ? (ByteBlock)writable : null;
        this.totalSize = -1;
    }

    public Tlv(ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(byteBlock, "tlvBytes");
        int n = byteBlock.getLength();
        if (n < 4) {
            throw new IllegalArgumentException("data not long enough to be a TLV (length=" + n + ")");
        }
        int n2 = BinaryTools.getUShort(byteBlock, 2);
        if (n2 > n - 4) {
            throw new IllegalArgumentException("data (length=" + n + ") not long enough to fulfill " + "header-specified length (" + n2 + ")");
        }
        this.type = BinaryTools.getUShort(byteBlock, 0);
        this.data = byteBlock.subBlock(4, n2);
        this.writer = this.data;
        this.totalSize = n2 + 4;
    }

    public final int getType() {
        return this.type;
    }

    public final synchronized ByteBlock getData() {
        if (this.data == null) {
            this.data = ByteBlock.createByteBlock(this.writer);
        }
        return this.data;
    }

    public final LiveWritable getDataWriter() {
        return this.writer;
    }

    public final String getDataAsString() {
        return BinaryTools.getAsciiString(this.data);
    }

    public final int getDataAsUShort() {
        return BinaryTools.getUShort(this.data, 0);
    }

    public final long getDataAsUInt() {
        return BinaryTools.getUInt(this.data, 0);
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 4 + this.data.getLength();
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        BinaryTools.writeUShort(outputStream, (int)this.writer.getWritableLength());
        this.writer.write(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TLV: type=0x");
        stringBuffer.append(Integer.toHexString(this.type));
        if (this.data == null) {
            stringBuffer.append(" (no data block)");
        } else {
            int n = this.data.getLength();
            stringBuffer.append(", length=" + n);
            if (n > 0) {
                CharsetDecoder charsetDecoder = Charset.forName("US-ASCII").newDecoder();
                CharBuffer charBuffer = null;
                try {
                    charBuffer = charsetDecoder.decode(ByteBuffer.wrap(this.data.toByteArray()));
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
                boolean bl = false;
                if (charBuffer != null) {
                    stringBuffer.append(", ascii value=\"" + charBuffer.toString() + "\"");
                    bl = true;
                }
                if (n == 2) {
                    stringBuffer.append(", ushort value=" + this.getDataAsUShort());
                    bl = true;
                }
                if (n == 4) {
                    stringBuffer.append(", uint value=" + this.getDataAsUInt());
                    bl = true;
                }
                if (TlvTools.isCompleteTlvChain(this.data)) {
                    stringBuffer.append(", tlvchain value=" + TlvTools.readChain(this.data));
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append(" - hex: ");
                } else {
                    stringBuffer.append(": ");
                }
                stringBuffer.append(BinaryTools.describeData(this.data));
            }
        }
        return stringBuffer.toString();
    }
}

