/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.regex.Pattern;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import org.jitsi.service.configuration.ConfigurationService;

public abstract class PhoneNumberI18nService {
    private static ConfigurationService configService = ProtocolProviderActivator.getConfigurationService();
    private static final Pattern removedCharactersToNormalizedPhoneNumber = Pattern.compile("[-\\(\\)\\.\\\\\\/ ]");
    private static final Pattern removedCharactersToNormalizedIdentifier = Pattern.compile("[\\(\\) ]");
    private static final Pattern charactersFordialPadNumber2 = Pattern.compile("[abc]", 2);
    private static final Pattern charactersFordialPadNumber3 = Pattern.compile("[def]", 2);
    private static final Pattern charactersFordialPadNumber4 = Pattern.compile("[ghi]", 2);
    private static final Pattern charactersFordialPadNumber5 = Pattern.compile("[jkl]", 2);
    private static final Pattern charactersFordialPadNumber6 = Pattern.compile("[mno]", 2);
    private static final Pattern charactersFordialPadNumber7 = Pattern.compile("[pqrs]", 2);
    private static final Pattern charactersFordialPadNumber8 = Pattern.compile("[tuv]", 2);
    private static final Pattern charactersFordialPadNumber9 = Pattern.compile("[wxyz]", 2);

    public static String normalize(String possibleNumber) {
        String normalizedNumber = PhoneNumberI18nService.isPhoneNumber(possibleNumber) ? PhoneNumberI18nService.normalizePhoneNumber(possibleNumber) : PhoneNumberI18nService.normalizeIdentifier(possibleNumber);
        return normalizedNumber;
    }

    private static String normalizePhoneNumber(String phoneNumber) {
        phoneNumber = PhoneNumberI18nService.convertAlphaCharactersInNumber(phoneNumber);
        return removedCharactersToNormalizedPhoneNumber.matcher(phoneNumber).replaceAll("");
    }

    private static String normalizeIdentifier(String id) {
        return removedCharactersToNormalizedIdentifier.matcher(id).replaceAll("");
    }

    public static boolean phoneNumbersMatch(String aPhoneNumber, String bPhoneNumber) {
        String aPhoneNumberNormalized = PhoneNumberI18nService.normalize(aPhoneNumber);
        String bPhoneNumberNormalized = PhoneNumberI18nService.normalize(bPhoneNumber);
        return aPhoneNumberNormalized.equals(bPhoneNumberNormalized);
    }

    public static boolean isPhoneNumber(String possibleNumber) {
        if (possibleNumber.indexOf(64) == -1) {
            if (!possibleNumber.matches(".*[a-zA-Z].*")) {
                return true;
            }
            String tmpPossibleNumber = possibleNumber.replaceAll(" \\(\\)", "");
            if (configService.getBoolean("impl.gui.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS", true) && tmpPossibleNumber.startsWith("+")) {
                return true;
            }
        }
        return false;
    }

    private static String convertAlphaCharactersInNumber(String phoneNumber) {
        phoneNumber = charactersFordialPadNumber2.matcher(phoneNumber).replaceAll("2");
        phoneNumber = charactersFordialPadNumber3.matcher(phoneNumber).replaceAll("3");
        phoneNumber = charactersFordialPadNumber4.matcher(phoneNumber).replaceAll("4");
        phoneNumber = charactersFordialPadNumber5.matcher(phoneNumber).replaceAll("5");
        phoneNumber = charactersFordialPadNumber6.matcher(phoneNumber).replaceAll("6");
        phoneNumber = charactersFordialPadNumber7.matcher(phoneNumber).replaceAll("7");
        phoneNumber = charactersFordialPadNumber8.matcher(phoneNumber).replaceAll("8");
        return charactersFordialPadNumber9.matcher(phoneNumber).replaceAll("9");
    }
}

