/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.lang.ref.SoftReference;
import javax.media.Buffer;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.InDataSourceDesc;
import org.jitsi.util.Logger;

class InStreamDesc {
    private SoftReference<Buffer> buffer;
    public final InDataSourceDesc inDataSourceDesc;
    private SourceStream inStream;
    private long nonContributingReadCount;

    public InStreamDesc(SourceStream inStream, InDataSourceDesc inDataSourceDesc) {
        this.inStream = inStream;
        this.inDataSourceDesc = inDataSourceDesc;
    }

    public Buffer getBuffer(boolean create) {
        Buffer buffer;
        Buffer buffer2 = buffer = this.buffer == null ? null : this.buffer.get();
        if (buffer == null && create) {
            buffer = new Buffer();
            this.setBuffer(buffer);
        }
        return buffer;
    }

    public SourceStream getInStream() {
        return this.inStream;
    }

    public AudioMixingPushBufferDataSource getOutDataSource() {
        return this.inDataSourceDesc.outDataSource;
    }

    void incrementNonContributingReadCount(Logger logger) {
        if (logger.isTraceEnabled()) {
            ++this.nonContributingReadCount;
            if (this.nonContributingReadCount >= 0L) {
                logger.trace("Failed to read actual inputSamples more than " + this.nonContributingReadCount + " times from inputStream with hash code " + this.getInStream().hashCode());
                this.nonContributingReadCount = 0L;
            }
        }
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer == null ? null : new SoftReference<Buffer>(buffer);
    }

    public void setInStream(SourceStream inStream) {
        if (this.inStream != inStream) {
            this.inStream = inStream;
            this.setBuffer(null);
        }
    }
}

