/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Videobridge;

public class Conference {
    private final List<Content> contents = new LinkedList<Content>();
    private boolean expired = false;
    private final String focus;
    private final String id;
    private long lastActivityTime;
    private final Videobridge videobridge;

    public Conference(Videobridge videobridge, String id, String focus) {
        if (videobridge == null) {
            throw new NullPointerException("videoBridge");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (focus == null) {
            throw new NullPointerException("focus");
        }
        this.videobridge = videobridge;
        this.id = id;
        this.focus = focus;
    }

    public void describe(ColibriConferenceIQ iq) {
        iq.setID(this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Conference conference = this;
        synchronized (conference) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        try {
            this.getVideobridge().expireConference(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            for (Content content : this.getContents()) {
                try {
                    content.expire();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            throw throwable;
        }
        for (Content content : this.getContents()) {
            try {
                content.expire();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireContent(Content content) {
        boolean expireContent;
        List<Content> list = this.contents;
        synchronized (list) {
            if (this.contents.contains(content)) {
                this.contents.remove(content);
                expireContent = true;
            } else {
                expireContent = false;
            }
        }
        if (expireContent) {
            content.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content[] getContents() {
        List<Content> list = this.contents;
        synchronized (list) {
            return this.contents.toArray(new Content[this.contents.size()]);
        }
    }

    public final String getFocus() {
        return this.focus;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Conference conference = this;
        synchronized (conference) {
            return this.lastActivityTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content getOrCreateContent(String name) {
        List<Content> list = this.contents;
        synchronized (list) {
            for (Content content : this.contents) {
                if (!content.getName().equals(name)) continue;
                content.touch();
                return content;
            }
            Content content = new Content(this, name);
            this.contents.add(content);
            return content;
        }
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Conference conference = this;
        synchronized (conference) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }
}

