/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.log.Log;

public class Scanner
implements Runnable {
    private int _scanInterval;
    private List _listeners = Collections.synchronizedList(new ArrayList());
    private Map _prevScan = Collections.EMPTY_MAP;
    private FilenameFilter _filter;
    private File _scanDir;
    private Thread _thread;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }

    public void setScanDir(File dir) {
        this._scanDir = dir;
    }

    public File getScanDir() {
        return this._scanDir;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public void run() {
        long sleepMillis = (long)this.getScanInterval() * 1000L;
        if (this._reportExisting) {
            this.scan();
        } else {
            this._prevScan = this.scanFiles();
        }
        this._running = true;
        while (this._running) {
            try {
                Thread.sleep(sleepMillis);
                this.scan();
            }
            catch (InterruptedException e) {
                this._running = false;
            }
        }
    }

    public void start() {
        if (this._running) {
            throw new IllegalStateException("Already running");
        }
        this._thread = new Thread((Runnable)this, "scanner");
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop() {
        if (this._running) {
            this._thread.interrupt();
        }
    }

    public void scan() {
        Map currentScan = this.scanFiles();
        this.reportDifferences(currentScan, this._prevScan);
        this._prevScan = currentScan;
    }

    public Map scanFiles() {
        File dir = this.getScanDir();
        Log.debug("Scanning directory " + this.getScanDir());
        HashMap scanInfo = new HashMap();
        if (dir != null && dir.exists()) {
            this.scanFile(dir, scanInfo);
        }
        Log.debug("Scan complete at " + new Date());
        return scanInfo;
    }

    public void reportDifferences(Map currentScan, Map oldScan) {
        HashSet oldScanKeys = new HashSet(oldScan.keySet());
        Iterator itor = currentScan.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            if (!oldScanKeys.contains(entry.getKey())) {
                Log.debug("File added: " + entry.getKey());
                this.reportAddition((String)entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                Log.debug("File changed: " + entry.getKey());
                this.reportChange((String)entry.getKey());
                oldScanKeys.remove(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            Iterator keyItor = oldScanKeys.iterator();
            while (keyItor.hasNext()) {
                String filename = (String)keyItor.next();
                Log.debug("File removed: " + filename);
                this.reportRemoval(filename);
            }
        }
    }

    private void scanFile(File f, Map scanInfoMap) {
        try {
            if (!f.exists()) {
                return;
            }
            if (f.isFile()) {
                Log.debug("Checking file " + f.getName());
                if (this._filter == null || this._filter != null && this._filter.accept(f.getParentFile(), f.getName())) {
                    Log.debug("File accepted");
                    String name = f.getCanonicalPath();
                    long lastModified = f.lastModified();
                    scanInfoMap.put(name, new Long(lastModified));
                }
            } else if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scanFile(files[i], scanInfoMap);
                }
            }
        }
        catch (IOException e) {
            Log.warn("Error scanning watched files", e);
        }
    }

    private void reportAddition(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                ((Listener)itor.next()).fileAdded(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    private void reportRemoval(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                ((Listener)itor.next()).fileRemoved(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    private void reportChange(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                ((Listener)itor.next()).fileChanged(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    public static interface Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }
}

