/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import org.jivesoftware.database.AbstractConnection;
import org.jivesoftware.database.CallableStatementWrapper;
import org.jivesoftware.database.PreparedStatementWrapper;
import org.jivesoftware.database.ProfiledConnectionEntry;
import org.jivesoftware.database.StatementWrapper;

public class ProfiledConnection
extends AbstractConnection {
    private static long startInsertTime = 0L;
    private static long startUpdateTime = 0L;
    private static long startSelectTime = 0L;
    private static long startDeleteTime = 0L;
    private static long endInsertTime = 0L;
    private static long endUpdateTime = 0L;
    private static long endSelectTime = 0L;
    private static long endDeleteTime = 0L;
    private static long insertCount = 0L;
    private static long updateCount = 0L;
    private static long selectCount = 0L;
    private static long deleteCount = 0L;
    private static long totalInsertTime = 0L;
    private static long totalUpdateTime = 0L;
    private static long totalSelectTime = 0L;
    private static long totalDeleteTime = 0L;
    private static Map<String, ProfiledConnectionEntry> insertQueries = new Hashtable<String, ProfiledConnectionEntry>();
    private static Map<String, ProfiledConnectionEntry> updateQueries = new Hashtable<String, ProfiledConnectionEntry>();
    private static Map<String, ProfiledConnectionEntry> selectQueries = new Hashtable<String, ProfiledConnectionEntry>();
    private static Map<String, ProfiledConnectionEntry> deleteQueries = new Hashtable<String, ProfiledConnectionEntry>();

    public static void start() {
        long now;
        startSelectTime = startDeleteTime = (now = System.currentTimeMillis());
        startUpdateTime = startDeleteTime;
        startInsertTime = startDeleteTime;
    }

    public static void stop() {
        endDeleteTime = 0L;
        endSelectTime = 0L;
        endUpdateTime = 0L;
        endInsertTime = 0L;
    }

    public static long getQueryCount(Type type) {
        switch (type) {
            case select: {
                return selectCount;
            }
            case update: {
                return updateCount;
            }
            case insert: {
                return insertCount;
            }
            case delete: {
                return deleteCount;
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public static void addQuery(Type type, String sql, long time) {
        ProfiledConnectionEntry entry;
        if (sql == null || sql.equals("")) {
            return;
        }
        sql = ProfiledConnection.reformatQuery(sql);
        sql = ProfiledConnection.removeQueryValues(sql);
        switch (type) {
            case select: {
                ++selectCount;
                totalSelectTime += time;
                entry = selectQueries.get(sql);
                if (entry != null) break;
                entry = new ProfiledConnectionEntry(sql);
                selectQueries.put(sql, entry);
                break;
            }
            case update: {
                ++updateCount;
                totalUpdateTime += time;
                entry = updateQueries.get(sql);
                if (entry != null) break;
                entry = new ProfiledConnectionEntry(sql);
                updateQueries.put(sql, entry);
                break;
            }
            case insert: {
                ++insertCount;
                totalInsertTime += time;
                entry = insertQueries.get(sql);
                if (entry != null) break;
                entry = new ProfiledConnectionEntry(sql);
                insertQueries.put(sql, entry);
                break;
            }
            case delete: {
                ++deleteCount;
                totalDeleteTime += time;
                entry = deleteQueries.get(sql);
                if (entry != null) break;
                entry = new ProfiledConnectionEntry(sql);
                deleteQueries.put(sql, entry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        ++entry.count;
        entry.totalTime = (int)((long)entry.totalTime + time);
    }

    public static double getQueriesPerSecond(Type type) {
        long end;
        long start;
        long count;
        switch (type) {
            case select: {
                count = selectCount;
                start = startSelectTime;
                end = endSelectTime;
                break;
            }
            case update: {
                count = updateCount;
                start = startUpdateTime;
                end = endUpdateTime;
                break;
            }
            case insert: {
                count = insertCount;
                start = startInsertTime;
                end = endInsertTime;
                break;
            }
            case delete: {
                count = deleteCount;
                start = startDeleteTime;
                end = endDeleteTime;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        if (count == 0L) {
            return 0.0;
        }
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        double time = (double)(end - start) / 1000.0;
        return (double)count / time;
    }

    public static double getAverageQueryTime(Type type) {
        long time;
        long count;
        switch (type) {
            case select: {
                count = selectCount;
                time = totalSelectTime;
                break;
            }
            case update: {
                count = updateCount;
                time = totalUpdateTime;
                break;
            }
            case insert: {
                count = insertCount;
                time = totalInsertTime;
                break;
            }
            case delete: {
                count = deleteCount;
                time = totalDeleteTime;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        if (count != 0L) {
            return (double)time / (double)count;
        }
        return 0.0;
    }

    public static long getTotalQueryTime(Type type) {
        switch (type) {
            case select: {
                return totalSelectTime;
            }
            case update: {
                return totalUpdateTime;
            }
            case insert: {
                return totalInsertTime;
            }
            case delete: {
                return totalDeleteTime;
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public static ProfiledConnectionEntry[] getSortedQueries(Type type, boolean sortByTime) {
        Map<String, ProfiledConnectionEntry> queries;
        switch (type) {
            case select: {
                queries = selectQueries;
                break;
            }
            case update: {
                queries = updateQueries;
                break;
            }
            case insert: {
                queries = insertQueries;
                break;
            }
            case delete: {
                queries = deleteQueries;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        if (queries.isEmpty()) {
            return null;
        }
        ProfiledConnectionEntry[] result = queries.values().toArray(new ProfiledConnectionEntry[queries.size()]);
        ProfiledConnection.quickSort(result, sortByTime, 0, result.length - 1);
        return result;
    }

    public static void resetStatistics() {
        startDeleteTime = 0L;
        startSelectTime = 0L;
        startUpdateTime = 0L;
        startInsertTime = 0L;
        endDeleteTime = 0L;
        endSelectTime = 0L;
        endUpdateTime = 0L;
        endInsertTime = 0L;
        deleteCount = 0L;
        selectCount = 0L;
        updateCount = 0L;
        insertCount = 0L;
        totalDeleteTime = 0L;
        totalSelectTime = 0L;
        totalUpdateTime = 0L;
        totalInsertTime = 0L;
        insertQueries.clear();
        updateQueries.clear();
        selectQueries.clear();
        deleteQueries.clear();
    }

    private static void quickSort(ProfiledConnectionEntry[] entries, boolean sortByTime, int first, int last) {
        if (first >= last || entries.length < 2) {
            return;
        }
        ProfiledConnection.swap(entries, first, (first + last) / 2);
        int index = first;
        for (int i = first + 1; i <= last; ++i) {
            if (sortByTime && entries[first].totalTime / entries[first].count < entries[i].totalTime / entries[i].count) {
                ProfiledConnection.swap(entries, ++index, i);
                continue;
            }
            if (sortByTime || entries[first].count >= entries[i].count) continue;
            ProfiledConnection.swap(entries, ++index, i);
        }
        ProfiledConnection.swap(entries, first, index);
        ProfiledConnection.quickSort(entries, sortByTime, first, index - 1);
        ProfiledConnection.quickSort(entries, sortByTime, index + 1, last);
    }

    private static void swap(Object[] list, int i, int j) {
        Object tmp = list[i];
        list[i] = list[j];
        list[j] = tmp;
    }

    private static String removeQueryValues(String _sql) {
        int length = _sql.length();
        if (_sql.indexOf("=") == -1) {
            return _sql;
        }
        StringBuilder sql = new StringBuilder(_sql);
        boolean inValue = false;
        boolean afterEquals = false;
        boolean hasQuotes = false;
        int startValue = -1;
        int endValue = -1;
        int charRemoved = 0;
        for (int x = 0; x < length; ++x) {
            char c = _sql.charAt(x);
            switch (c) {
                case '=': {
                    if (afterEquals) break;
                    afterEquals = true;
                    break;
                }
                case ' ': {
                    if (hasQuotes || !inValue) break;
                    endValue = x;
                    inValue = false;
                    hasQuotes = false;
                    afterEquals = false;
                    break;
                }
                case '\'': {
                    if (afterEquals && !inValue) {
                        startValue = x;
                        inValue = true;
                        hasQuotes = true;
                        break;
                    }
                    if (!afterEquals || !inValue || !hasQuotes) break;
                    endValue = x + 1;
                    inValue = false;
                    hasQuotes = false;
                    afterEquals = false;
                    break;
                }
                case '-': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '+': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '0': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '1': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '2': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '3': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '4': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '5': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '6': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '7': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '8': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                case '9': {
                    if (!afterEquals || inValue) break;
                    startValue = x;
                    inValue = true;
                    break;
                }
                default: {
                    if (!afterEquals || inValue) break;
                    afterEquals = false;
                }
            }
            if (x == length - 1 && afterEquals) {
                endValue = x + 1;
            }
            if (startValue == -1 || endValue == -1) continue;
            sql.replace(startValue - charRemoved, endValue - charRemoved, "?");
            charRemoved += endValue - startValue - 1;
            startValue = -1;
            endValue = -1;
        }
        return sql.toString();
    }

    private static String reformatQuery(String _sql) {
        int length = _sql.length();
        int charAdded = 0;
        StringBuilder sql = new StringBuilder(_sql);
        for (int x = 0; x < length; ++x) {
            char c = _sql.charAt(x);
            if (c != ',' || x >= length - 1 || _sql.charAt(x + 1) == ' ') continue;
            sql.replace(x + charAdded, x + 1 + charAdded, ", ");
            ++charAdded;
        }
        return sql.toString();
    }

    public ProfiledConnection(Connection connection) {
        super(connection);
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Statement createStatement() throws SQLException {
        return new TimedStatement(this.connection.createStatement());
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new TimedPreparedStatement(this.connection.prepareStatement(sql), sql);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TimedStatement(this.connection.createStatement(resultSetType, resultSetConcurrency));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TimedPreparedStatement(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new TimedCallableStatement(this.connection.prepareCall(sql), sql);
    }

    public CallableStatement prepareCall(String sql, int i, int i1) throws SQLException {
        return new TimedCallableStatement(this.connection.prepareCall(sql, i, i1), sql);
    }

    class TimedCallableStatement
    extends CallableStatementWrapper {
        private String sql;
        private Type type;

        public TimedCallableStatement(CallableStatement cstmt, String sql) {
            super(cstmt);
            this.type = Type.select;
            this.sql = sql;
            String sqlL = sql.toLowerCase().trim();
            this.type = sqlL.startsWith("insert") ? Type.insert : (sqlL.startsWith("update") ? Type.update : (sqlL.startsWith("delete") ? Type.delete : Type.select));
        }

        public boolean execute() throws SQLException {
            long t1 = System.currentTimeMillis();
            boolean result = this.cstmt.execute();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public ResultSet executeQuery() throws SQLException {
            long t1 = System.currentTimeMillis();
            ResultSet result = this.cstmt.executeQuery();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public int executeUpdate() throws SQLException {
            long t1 = System.currentTimeMillis();
            int result = this.cstmt.executeUpdate();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public boolean execute(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            boolean result = this.cstmt.execute(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }

        public int[] executeBatch() throws SQLException {
            long t1 = System.currentTimeMillis();
            int[] result = this.cstmt.executeBatch();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public ResultSet executeQuery(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            ResultSet result = this.cstmt.executeQuery(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }

        public int executeUpdate(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            int result = this.cstmt.executeUpdate(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }
    }

    class TimedPreparedStatement
    extends PreparedStatementWrapper {
        private String sql;
        private Type type;

        public TimedPreparedStatement(PreparedStatement pstmt, String sql) {
            super(pstmt);
            this.type = Type.select;
            this.sql = sql;
            String sqlL = sql.toLowerCase().trim();
            this.type = sqlL.startsWith("insert") ? Type.insert : (sqlL.startsWith("update") ? Type.update : (sqlL.startsWith("delete") ? Type.delete : Type.select));
        }

        public boolean execute() throws SQLException {
            long t1 = System.currentTimeMillis();
            boolean result = this.pstmt.execute();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public ResultSet executeQuery() throws SQLException {
            long t1 = System.currentTimeMillis();
            ResultSet result = this.pstmt.executeQuery();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public int executeUpdate() throws SQLException {
            long t1 = System.currentTimeMillis();
            int result = this.pstmt.executeUpdate();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public boolean execute(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            boolean result = this.pstmt.execute(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }

        public int[] executeBatch() throws SQLException {
            long t1 = System.currentTimeMillis();
            int[] result = this.pstmt.executeBatch();
            long t2 = System.currentTimeMillis();
            switch (this.type) {
                case select: {
                    ProfiledConnection.addQuery(Type.select, this.sql, t2 - t1);
                    break;
                }
                case update: {
                    ProfiledConnection.addQuery(Type.update, this.sql, t2 - t1);
                    break;
                }
                case insert: {
                    ProfiledConnection.addQuery(Type.insert, this.sql, t2 - t1);
                    break;
                }
                case delete: {
                    ProfiledConnection.addQuery(Type.delete, this.sql, t2 - t1);
                }
            }
            return result;
        }

        public ResultSet executeQuery(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            ResultSet result = this.pstmt.executeQuery(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }

        public int executeUpdate(String _sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            int result = this.pstmt.executeUpdate(_sql);
            long t2 = System.currentTimeMillis();
            String sqlL = _sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, _sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, _sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, _sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, _sql, t2 - t1);
            }
            return result;
        }
    }

    class TimedStatement
    extends StatementWrapper {
        private Statement stmt;

        public TimedStatement(Statement stmt) {
            super(stmt);
            this.stmt = stmt;
        }

        public boolean execute(String sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            boolean result = this.stmt.execute(sql);
            long t2 = System.currentTimeMillis();
            String sqlL = sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, sql, t2 - t1);
            }
            return result;
        }

        public ResultSet executeQuery(String sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            ResultSet result = this.stmt.executeQuery(sql);
            long t2 = System.currentTimeMillis();
            String sqlL = sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, sql, t2 - t1);
            }
            return result;
        }

        public int executeUpdate(String sql) throws SQLException {
            long t1 = System.currentTimeMillis();
            int result = this.stmt.executeUpdate(sql);
            long t2 = System.currentTimeMillis();
            String sqlL = sql.toLowerCase().trim();
            if (sqlL.startsWith("insert")) {
                ProfiledConnection.addQuery(Type.insert, sql, t2 - t1);
            } else if (sqlL.startsWith("update")) {
                ProfiledConnection.addQuery(Type.update, sql, t2 - t1);
            } else if (sqlL.startsWith("delete")) {
                ProfiledConnection.addQuery(Type.delete, sql, t2 - t1);
            } else {
                ProfiledConnection.addQuery(Type.select, sql, t2 - t1);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        select,
        update,
        insert,
        delete;

    }
}

