/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CannotRealizeException;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.DataSinkProxy;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSinkException;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceCloneable;
import javax.media.protocol.URLDataSource;
import net.sf.fmj.ejmf.toolkit.util.StateWaiter;
import net.sf.fmj.media.MergingCaptureDevicePullBufferDataSource;
import net.sf.fmj.media.MergingCaptureDevicePullDataSource;
import net.sf.fmj.media.MergingCaptureDevicePushBufferDataSource;
import net.sf.fmj.media.MergingCaptureDevicePushDataSource;
import net.sf.fmj.media.MergingPullBufferDataSource;
import net.sf.fmj.media.MergingPullDataSource;
import net.sf.fmj.media.MergingPushBufferDataSource;
import net.sf.fmj.media.MergingPushDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePullBufferDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePullDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePushBufferDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePushDataSource;
import net.sf.fmj.media.protocol.CloneablePullBufferDataSource;
import net.sf.fmj.media.protocol.CloneablePullDataSource;
import net.sf.fmj.media.protocol.CloneablePushBufferDataSource;
import net.sf.fmj.media.protocol.CloneablePushDataSource;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager {
    public static final String FMJ_TAG = "FMJ";
    private static final boolean USE_MEDIA_PREFIX = false;
    private static final Logger logger = LoggerSingleton.logger;
    public static final int MAX_SECURITY = 1;
    public static final int CACHING = 2;
    public static final int LIGHTWEIGHT_RENDERER = 3;
    public static final int PLUGIN_PLAYER = 4;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static TimeBase systemTimeBase = new SystemTimeBase();
    private static final Map<Integer, Object> hints = new HashMap<Integer, Object>();
    public static final boolean RETHROW_IO_EXCEPTIONS = true;

    private static void blockingRealize(Controller controller) throws CannotRealizeException {
        try {
            new BlockingRealizer(controller).realize();
        }
        catch (InterruptedException e) {
            throw new CannotRealizeException("Interrupted");
        }
    }

    public static DataSource createCloneableDataSource(DataSource source) {
        if (source instanceof SourceCloneable) {
            return source;
        }
        if (source instanceof PushBufferDataSource) {
            if (source instanceof CaptureDevice) {
                return new CloneableCaptureDevicePushBufferDataSource((PushBufferDataSource)source);
            }
            return new CloneablePushBufferDataSource((PushBufferDataSource)source);
        }
        if (source instanceof PullBufferDataSource) {
            if (source instanceof CaptureDevice) {
                return new CloneableCaptureDevicePullBufferDataSource((PullBufferDataSource)source);
            }
            return new CloneablePullBufferDataSource((PullBufferDataSource)source);
        }
        if (source instanceof PushDataSource) {
            if (source instanceof CaptureDevice) {
                return new CloneableCaptureDevicePushDataSource((PushDataSource)source);
            }
            return new CloneablePushDataSource((PushDataSource)source);
        }
        if (source instanceof PullDataSource) {
            if (source instanceof CaptureDevice) {
                return new CloneableCaptureDevicePullDataSource((PullDataSource)source);
            }
            return new CloneablePullDataSource((PullDataSource)source);
        }
        throw new IllegalArgumentException("Unknown or unsupported DataSource type: " + source);
    }

    public static DataSink createDataSink(DataSource datasource, MediaLocator destLocator) throws NoDataSinkException {
        String protocol = destLocator.getProtocol();
        for (String handlerClassName : Manager.getDataSinkClassList(protocol)) {
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!DataSink.class.isAssignableFrom(handlerClass) && !DataSinkProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(datasource);
                if (handler instanceof DataSink) {
                    DataSink dataSink = (DataSink)handler;
                    dataSink.setOutputLocator(destLocator);
                    return dataSink;
                }
                if (!(handler instanceof DataSinkProxy)) continue;
                DataSinkProxy mediaProxy = (DataSinkProxy)handler;
                Vector<String> handlerClassList2 = Manager.getDataSinkClassList(protocol + "." + Manager.toPackageFriendly(mediaProxy.getContentType(destLocator)));
                for (String handlerClassName2 : handlerClassList2) {
                    try {
                        Class<?> handlerClass2 = Class.forName(handlerClassName2);
                        if (!DataSink.class.isAssignableFrom(handlerClass2)) continue;
                        MediaHandler handler2 = (MediaHandler)handlerClass2.newInstance();
                        handler2.setSource(mediaProxy.getDataSource());
                        if (!(handler2 instanceof DataSink)) continue;
                        DataSink dataSink = (DataSink)handler2;
                        dataSink.setOutputLocator(destLocator);
                        return (DataSink)handler2;
                    }
                    catch (ClassNotFoundException e) {
                        logger.finer("createDataSink: " + e);
                    }
                    catch (IncompatibleSourceException e) {
                        logger.fine("createDataSink(" + datasource + ", " + destLocator + "), proxy=" + mediaProxy.getDataSource() + ": " + e);
                    }
                    catch (NoClassDefFoundError e) {
                        logger.log(Level.FINE, "" + e, e);
                    }
                    catch (Exception e) {
                        logger.log(Level.FINE, "" + e, e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSink: " + e);
            }
            catch (IncompatibleSourceException e) {
                logger.fine("createDataSink(" + datasource + ", " + destLocator + "): " + e);
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoDataSinkException();
    }

    private static DataSink createDataSink(DataSource datasource, String protocol) throws NoDataSinkException {
        for (String handlerClassName : Manager.getDataSinkClassList(protocol)) {
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!DataSink.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(datasource);
                if (!(handler instanceof DataSink)) continue;
                return (DataSink)handler;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSink: " + e);
            }
            catch (IncompatibleSourceException e) {
                logger.fine("createDataSink(" + datasource + ", " + protocol + "): " + e);
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoDataSinkException();
    }

    public static DataSource createDataSource(URL sourceURL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(sourceURL));
    }

    public static DataSource createDataSource(MediaLocator sourceLocator) throws IOException, NoDataSourceException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        for (String dataSourceClassName : Manager.getDataSourceList(protocol)) {
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return dataSource;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSource: " + e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoDataSourceException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return dataSource;
    }

    public static DataSource createMergingDataSource(DataSource[] sources) throws IncompatibleSourceException {
        ArrayList<PushBufferDataSource> sourcesCast;
        boolean allPushBufferDataSource = true;
        boolean allPullBufferDataSource = true;
        boolean allPushDataSource = true;
        boolean allPullDataSource = true;
        boolean allCaptureDevice = true;
        for (DataSource source : sources) {
            if (!(source instanceof PushBufferDataSource)) {
                allPushBufferDataSource = false;
            }
            if (!(source instanceof PullBufferDataSource)) {
                allPullBufferDataSource = false;
            }
            if (!(source instanceof PushDataSource)) {
                allPushDataSource = false;
            }
            if (!(source instanceof PullDataSource)) {
                allPullDataSource = false;
            }
            if (source instanceof CaptureDevice) continue;
            allCaptureDevice = false;
        }
        if (allPushBufferDataSource) {
            sourcesCast = new ArrayList<PushBufferDataSource>();
            for (DataSource source : sources) {
                sourcesCast.add((PushBufferDataSource)source);
            }
            if (allCaptureDevice) {
                return new MergingCaptureDevicePushBufferDataSource(sourcesCast);
            }
            return new MergingPushBufferDataSource(sourcesCast);
        }
        if (allPullBufferDataSource) {
            sourcesCast = new ArrayList();
            for (DataSource source : sources) {
                sourcesCast.add((PushBufferDataSource)((Object)((PullBufferDataSource)source)));
            }
            if (allCaptureDevice) {
                return new MergingCaptureDevicePullBufferDataSource(sourcesCast);
            }
            return new MergingPullBufferDataSource(sourcesCast);
        }
        if (allPushDataSource) {
            sourcesCast = new ArrayList();
            for (DataSource source : sources) {
                sourcesCast.add((PushBufferDataSource)((Object)((PushDataSource)source)));
            }
            if (allCaptureDevice) {
                return new MergingCaptureDevicePushDataSource(sourcesCast);
            }
            return new MergingPushDataSource(sourcesCast);
        }
        if (allPullDataSource) {
            sourcesCast = new ArrayList();
            for (DataSource source : sources) {
                sourcesCast.add((PushBufferDataSource)((Object)((PullDataSource)source)));
            }
            if (allCaptureDevice) {
                return new MergingCaptureDevicePullDataSource(sourcesCast);
            }
            return new MergingPullDataSource(sourcesCast);
        }
        throw new IncompatibleSourceException();
    }

    public static Player createPlayer(DataSource source) throws IOException, NoPlayerException {
        try {
            return Manager.createPlayer(source, source.getContentType());
        }
        catch (NoPlayerException e) {
        }
        catch (IOException e) {
            logger.log(Level.FINE, "" + e, e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINER, "" + e, e);
        }
        return Manager.createPlayer(source, UNKNOWN_CONTENT_NAME);
    }

    private static Player createPlayer(DataSource source, String contentType) throws IOException, NoPlayerException {
        ArrayList<String> classFoundHandlersTried = new ArrayList<String>();
        for (String handlerClassName : Manager.getHandlerClassList(contentType)) {
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!Player.class.isAssignableFrom(handlerClass) && !MediaProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(source);
                if (handler instanceof Player) {
                    logger.info("Using player: " + handler.getClass().getName());
                    return (Player)handler;
                }
                if (handler instanceof MediaProxy) {
                    MediaProxy mediaProxy = (MediaProxy)handler;
                    return Manager.createPlayer(mediaProxy.getDataSource());
                }
                logger.fine("Not Player, and not MediaProxy: " + handler.getClass().getName());
                classFoundHandlersTried.add(handlerClassName);
            }
            catch (ClassNotFoundException e) {
                logger.finer("createPlayer: " + e);
            }
            catch (IncompatibleSourceException e) {
                classFoundHandlersTried.add(handlerClassName);
                logger.fine("createPlayer(" + source + ", " + contentType + "): " + e);
            }
            catch (IOException e) {
                classFoundHandlersTried.add(handlerClassName);
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoPlayerException e) {
                classFoundHandlersTried.add(handlerClassName);
            }
            catch (NoClassDefFoundError e) {
                classFoundHandlersTried.add(handlerClassName);
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                classFoundHandlersTried.add(handlerClassName);
                logger.log(Level.FINE, "" + e, e);
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("Tried handlers:");
        for (int i = 0; i < classFoundHandlersTried.size(); ++i) {
            b.append('\n');
            b.append((String)classFoundHandlersTried.get(i));
        }
        throw new NoPlayerException("No player found for " + source.getLocator() + " - " + b.toString());
    }

    public static Player createPlayer(URL sourceURL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(sourceURL));
    }

    public static Player createPlayer(MediaLocator sourceLocator) throws IOException, NoPlayerException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        for (String dataSourceClassName : Manager.getDataSourceList(protocol)) {
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return Manager.createPlayer(dataSource);
            }
            catch (NoPlayerException e) {
            }
            catch (ClassNotFoundException e) {
                logger.finer("createPlayer: " + e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoPlayerException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return Manager.createPlayer(dataSource);
    }

    public static Processor createProcessor(DataSource source) throws IOException, NoProcessorException {
        try {
            return Manager.createProcessor(source, source.getContentType());
        }
        catch (IOException e) {
            logger.log(Level.FINE, "" + e, e);
            throw e;
        }
        catch (NoProcessorException e) {
        }
        catch (Exception e) {
            logger.log(Level.FINE, "" + e, e);
        }
        return Manager.createProcessor(source, UNKNOWN_CONTENT_NAME);
    }

    private static Processor createProcessor(DataSource source, String contentType) throws IOException, NoProcessorException {
        for (String handlerClassName : Manager.getProcessorClassList(contentType)) {
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!Processor.class.isAssignableFrom(handlerClass) && !MediaProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(source);
                if (handler instanceof Processor) {
                    return (Processor)handler;
                }
                if (!(handler instanceof MediaProxy)) continue;
                MediaProxy mediaProxy = (MediaProxy)handler;
                return Manager.createProcessor(mediaProxy.getDataSource());
            }
            catch (ClassNotFoundException e) {
                logger.finer("createProcessor: " + e);
            }
            catch (IncompatibleSourceException e) {
                logger.fine("createProcessor(" + source + ", " + contentType + "): " + e);
            }
            catch (NoProcessorException e) {
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoProcessorException();
    }

    public static Processor createProcessor(URL sourceURL) throws IOException, NoProcessorException {
        return Manager.createProcessor(new MediaLocator(sourceURL));
    }

    public static Processor createProcessor(MediaLocator sourceLocator) throws IOException, NoProcessorException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        for (String dataSourceClassName : Manager.getDataSourceList(protocol)) {
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return Manager.createProcessor(dataSource);
            }
            catch (ClassNotFoundException e) {
                logger.finer("createProcessor: " + e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoProcessorException e) {
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoProcessorException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return Manager.createProcessor(dataSource);
    }

    public static Player createRealizedPlayer(DataSource source) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(source);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(URL sourceURL) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(sourceURL);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(MediaLocator ml) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(ml);
        Manager.blockingRealize(player);
        return player;
    }

    public static Processor createRealizedProcessor(ProcessorModel model) throws IOException, NoProcessorException, CannotRealizeException {
        Format[] outputFormats;
        int numTracks;
        Processor processor = model.getInputDataSource() != null ? Manager.createProcessor(model.getInputDataSource()) : Manager.createProcessor(model.getInputLocator());
        StateWaiter stateWaiter = new StateWaiter(processor);
        if (!stateWaiter.blockingConfigure()) {
            throw new CannotRealizeException("Failed to configure");
        }
        if (model.getContentDescriptor() != null) {
            processor.setContentDescriptor(model.getContentDescriptor());
        }
        if ((numTracks = model.getTrackCount(Integer.MAX_VALUE)) > 0) {
            outputFormats = new Format[numTracks];
            for (int i = 0; i < outputFormats.length; ++i) {
                outputFormats[i] = model.getOutputTrackFormat(i);
            }
        } else {
            outputFormats = null;
        }
        if (outputFormats != null && outputFormats.length > 0) {
            int i;
            Format outputFormat;
            int j;
            TrackControl[] trackControl = processor.getTrackControls();
            boolean[] trackConfigured = new boolean[trackControl.length];
            boolean[] outputFormatUsed = new boolean[outputFormats.length];
            for (j = 0; j < outputFormats.length; ++j) {
                outputFormat = outputFormats[j];
                if (outputFormat == null) continue;
                for (i = 0; i < trackControl.length; ++i) {
                    if (trackConfigured[i]) continue;
                    if (!(trackControl[i] instanceof FormatControl)) {
                        logger.warning("Disabling track " + i + "; trackControl is not a FormatControl: " + trackControl[i]);
                        trackControl[i].setEnabled(false);
                        trackConfigured[i] = true;
                        continue;
                    }
                    if (trackControl[i].setFormat(outputFormat) == null) {
                        logger.fine("Track " + i + "; does not accept " + outputFormat);
                        continue;
                    }
                    logger.fine("Using track " + i + "; accepted " + outputFormat);
                    trackConfigured[i] = true;
                    outputFormatUsed[j] = true;
                }
            }
            for (j = 0; j < outputFormats.length; ++j) {
                outputFormat = outputFormats[j];
                if (outputFormat != null) continue;
                for (i = 0; i < trackControl.length; ++i) {
                    if (trackConfigured[i]) continue;
                    logger.fine("Using track " + i + "; for unspecified format");
                    trackConfigured[i] = true;
                    outputFormatUsed[j] = true;
                }
            }
            for (int i2 = 0; i2 < trackControl.length; ++i2) {
                if (trackConfigured[i2]) continue;
                logger.info("Disabling track " + i2 + "; no format set.");
                trackControl[i2].setEnabled(false);
            }
            for (j = 0; j < outputFormats.length; ++j) {
                if (outputFormatUsed[j]) continue;
                throw new CannotRealizeException("No tracks found that are compatible with format " + outputFormats[j]);
            }
        }
        if (!stateWaiter.blockingRealize()) {
            throw new CannotRealizeException("Failed to realize");
        }
        return processor;
    }

    public static String getCacheDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Vector<String> getClassList(String contentName, Vector packages, String component2, String className) {
        Vector<String> result = new Vector<String>();
        for (Object aPackage : packages) {
            result.add(aPackage + ".media." + component2 + "." + contentName + "." + className);
        }
        return result;
    }

    public static Vector<String> getDataSinkClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "datasink", "Handler");
    }

    public static Vector<String> getDataSourceList(String protocolName) {
        return Manager.getClassList(protocolName, PackageManager.getProtocolPrefixList(), "protocol", "DataSource");
    }

    public static Vector<String> getHandlerClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "content", "Handler");
    }

    public static Object getHint(int hint) {
        return hints.get(hint);
    }

    public static Vector<String> getProcessorClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "processor", "Handler");
    }

    public static TimeBase getSystemTimeBase() {
        return systemTimeBase;
    }

    public static String getVersion() {
        try {
            Properties p = new Properties();
            p.load(Manager.class.getResourceAsStream("/fmj.build.properties"));
            String s = p.getProperty("build");
            if (s != null && !s.equals("")) {
                return "FMJ " + s.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "FMJ non-release x.x";
    }

    public static void setHint(int hint, Object value) {
        hints.put(hint, value);
    }

    private static char toPackageFriendly(char c) {
        if (c >= 'a' && c <= 'z') {
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c == '.') {
            return c;
        }
        if (c == '/') {
            return '.';
        }
        return '_';
    }

    private static String toPackageFriendly(String contentName) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < contentName.length(); ++i) {
            char c = contentName.charAt(i);
            b.append(Manager.toPackageFriendly(c));
        }
        return b.toString();
    }

    static {
        hints.put(1, Boolean.FALSE);
        hints.put(2, Boolean.TRUE);
        hints.put(3, Boolean.FALSE);
        hints.put(4, Boolean.FALSE);
    }

    private static class BlockingRealizer
    implements ControllerListener {
        private final Controller controller;
        private volatile boolean realized = false;
        private volatile boolean busy = true;
        private volatile String cannotRealizeExceptionMessage;

        public BlockingRealizer(Controller controller) {
            this.controller = controller;
        }

        public synchronized void controllerUpdate(ControllerEvent event) {
            if (event instanceof RealizeCompleteEvent) {
                this.realized = true;
                this.busy = false;
                this.notify();
            } else if (event instanceof StopEvent || event instanceof ControllerClosedEvent) {
                if (event instanceof StopEvent) {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received StopEvent: " + event;
                    logger.info(this.cannotRealizeExceptionMessage);
                } else {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received ControllerClosedEvent: " + event + "; message: " + ((ControllerClosedEvent)event).getMessage();
                    logger.info(this.cannotRealizeExceptionMessage);
                }
                this.realized = false;
                this.busy = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void realize() throws CannotRealizeException, InterruptedException {
            this.controller.addControllerListener(this);
            this.controller.realize();
            while (this.busy) {
                try {
                    BlockingRealizer blockingRealizer = this;
                    synchronized (blockingRealizer) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.controller.removeControllerListener(this);
                    throw e;
                }
            }
            this.controller.removeControllerListener(this);
            if (!this.realized) {
                throw new CannotRealizeException(this.cannotRealizeExceptionMessage);
            }
        }
    }
}

