/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.utils;

import gnu.java.zrtp.utils.ZrtpUtils;

public class Base32 {
    private static final char[] chars = "ybndrfg8ejkmcpqxot1uwisza345h769".toCharArray();
    private static int[] revchars = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 18, 255, 25, 26, 27, 30, 29, 7, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 24, 1, 12, 3, 8, 5, 6, 28, 21, 9, 10, 255, 11, 2, 16, 13, 14, 4, 22, 17, 19, 255, 20, 15, 0, 23, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};

    private static int divceil(int a, int b) {
        int c = a > 0 ? (b > 0 ? a + b - 1 : a) : (b > 0 ? a : a + b + 1);
        return c / b;
    }

    public static String binary2ascii(byte[] os, int lengthInBits) {
        int len = (lengthInBits + 7) / 8;
        char[] result = new char[Base32.divceil(len * 8, 5)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 32;
        }
        int resp = result.length;
        int x = 0;
        int switcher = len % 5;
        do {
            switch (switcher) {
                case 0: {
                    x = os[--len] & 0xFF;
                    result[--resp] = chars[x % 32];
                    x /= 32;
                }
                case 4: {
                    result[--resp] = chars[(x |= (os[--len] & 0xFF) << 3) % 32];
                    result[--resp] = chars[(x /= 32) % 32];
                    x /= 32;
                }
                case 3: {
                    result[--resp] = chars[(x |= (os[--len] & 0xFF) << 1) % 32];
                    x /= 32;
                }
                case 2: {
                    result[--resp] = chars[(x |= (os[--len] & 0xFF) << 4) % 32];
                    result[--resp] = chars[(x /= 32) % 32];
                    x /= 32;
                }
                case 1: {
                    result[--resp] = chars[(x |= (os[--len] & 0xFF) << 2) % 32];
                    result[--resp] = chars[x /= 32];
                }
            }
            switcher = 0;
        } while (len > 0);
        String encoded = new String(result, 0, Base32.divceil(lengthInBits, 5));
        return encoded;
    }

    public static byte[] ascii2binary(String cs, int lengthInBits) {
        int x = 0;
        int size = Base32.divceil(lengthInBits, 5);
        int len = Base32.divceil(size * 5, 8);
        byte[] binaryResult = new byte[len];
        int resp = binaryResult.length;
        int csp = size;
        int switcher = csp % 8;
        do {
            switch (switcher) {
                case 0: {
                    x = revchars[cs.charAt(--csp) & 0xFF];
                }
                case 7: {
                    binaryResult[--resp] = (byte)((x |= revchars[cs.charAt(--csp) & 0xFF] << 5) % 256);
                    x /= 256;
                }
                case 6: {
                    x |= revchars[cs.charAt(--csp) & 0xFF] << 2;
                }
                case 5: {
                    binaryResult[--resp] = (byte)((x |= revchars[cs.charAt(--csp) & 0xFF] << 7) % 256);
                    x /= 256;
                }
                case 4: {
                    binaryResult[--resp] = (byte)((x |= revchars[cs.charAt(--csp) & 0xFF] << 4) % 256);
                    x /= 256;
                }
                case 3: {
                    x |= revchars[cs.charAt(--csp) & 0xFF] << 1;
                }
                case 2: {
                    binaryResult[--resp] = (byte)((x |= revchars[cs.charAt(--csp) & 0xFF] << 6) % 256);
                    x /= 256;
                }
                case 1: {
                    binaryResult[--resp] = (byte)((x |= revchars[cs.charAt(--csp) & 0xFF] << 3) % 256);
                }
            }
            switcher = 0;
        } while (csp > 0);
        int resultLength = Base32.divceil(lengthInBits, 8);
        if (resultLength < len) {
            byte[] shorterResult = new byte[resultLength];
            System.arraycopy(binaryResult, 0, shorterResult, 0, shorterResult.length);
            return shorterResult;
        }
        return binaryResult;
    }

    public static void main(String[] args) {
        byte[] ones = new byte[]{1, 1, 1, 1, 1};
        byte[] onesMore = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] eightOne = new byte[]{-127, -127, -127, -127, -127, -127, -127, -127};
        String encoded = Base32.binary2ascii(ones, 40);
        System.err.println("Endcoded zeroOne, 40bits (expected: 'yryonyeb'): " + encoded);
        encoded = Base32.binary2ascii(ones, 15);
        System.err.println("Endcoded zeroOne, 15bits (expected: 'yry'): " + encoded);
        encoded = Base32.binary2ascii(onesMore, 80);
        System.err.println("Endcoded zeroOne, 80bits (expected: 'yryonyebyryonyeb'): " + encoded);
        byte[] decoded = Base32.ascii2binary(encoded, 80);
        ZrtpUtils.hexdump("Decoded 80 bits zeroOne", decoded, decoded.length);
        decoded = Base32.ascii2binary(encoded, 8);
        ZrtpUtils.hexdump("Decoded 8 bits zeroOne", decoded, decoded.length);
        encoded = Base32.binary2ascii(eightOne, 15);
        System.err.println("Endcoded eightOne, 15bits (expected: 'ogy'): " + encoded);
        encoded = Base32.binary2ascii(eightOne, 16);
        System.err.println("Endcoded eightOne, 16bits (expected: 'ogyo'): " + encoded);
        encoded = Base32.binary2ascii(eightOne, 20);
        System.err.println("Endcoded eightOne, 20bits (expected: 'ogya'): " + encoded);
        encoded = Base32.binary2ascii(eightOne, 64);
        System.err.println("Endcoded eightOne, 64bits (expected: 'ogyadycbogyan'): " + encoded);
        decoded = Base32.ascii2binary(encoded, 7);
        ZrtpUtils.hexdump("Decoded 7 bits eightOne", decoded, decoded.length);
        decoded = Base32.ascii2binary(encoded, 8);
        ZrtpUtils.hexdump("Decoded 8 bits eightOne", decoded, decoded.length);
        decoded = Base32.ascii2binary(encoded, 15);
        ZrtpUtils.hexdump("Decoded 15 bits eightOne", decoded, decoded.length);
        decoded = Base32.ascii2binary(encoded, 16);
        ZrtpUtils.hexdump("Decoded 16 bits eightOne", decoded, decoded.length);
        decoded = Base32.ascii2binary(encoded, 64);
        ZrtpUtils.hexdump("Decoded 64 bits eightOne", decoded, decoded.length);
    }
}

