/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class NUp
extends AbstractTool {
    static {
        NUp.addVersion("$Id: NUp.java,v 1.7 2006/08/24 10:01:13 blowagie Exp $");
    }

    public NUp() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to N-up", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The resulting PDF", true, new PdfFilter()));
        OptionArgument oa = new OptionArgument(this, "pow2", "The number of pages you want to copy to 1 page");
        oa.addOption("2", "1");
        oa.addOption("4", "2");
        oa.addOption("8", "3");
        oa.addOption("16", "4");
        oa.addOption("32", "5");
        oa.addOption("64", "6");
        this.arguments.add(oa);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("N-up", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== N-up OPENED ===");
    }

    public void execute() {
        try {
            int pow2;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            try {
                pow2 = Integer.parseInt((String)this.getValue("pow2"));
            }
            catch (Exception e) {
                pow2 = 1;
            }
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int total = reader.getNumberOfPages();
            System.out.println("There are " + total + " pages in the original file.");
            Rectangle pageSize = reader.getPageSize(1);
            Rectangle newSize = pow2 % 2 == 0 ? new Rectangle(pageSize.width(), pageSize.height()) : new Rectangle(pageSize.height(), pageSize.width());
            Rectangle unitSize = new Rectangle(pageSize.width(), pageSize.height());
            int i = 0;
            while (i < pow2) {
                unitSize = new Rectangle(unitSize.height() / 2.0f, unitSize.width());
                ++i;
            }
            int n = (int)Math.pow(2.0, pow2);
            int r = (int)Math.pow(2.0, pow2 / 2);
            int c = n / r;
            Document document = new Document(newSize, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(dest));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int i2 = 0;
            while (i2 < total) {
                if (i2 % n == 0) {
                    document.newPage();
                }
                int p = i2 + 1;
                float offsetX = unitSize.width() * (float)(i2 % n % c);
                float offsetY = newSize.height() - unitSize.height() * (float)(i2 % n / c + 1);
                Rectangle currentSize = reader.getPageSize(p);
                float factor = Math.min(unitSize.width() / currentSize.width(), unitSize.height() / currentSize.height());
                PdfImportedPage page = writer.getImportedPage(reader, p);
                cb.addTemplate(page, factor, 0.0f, 0.0f, factor, offsetX += (unitSize.width() - currentSize.width() * factor) / 2.0f, offsetY += (unitSize.height() - currentSize.height() * factor) / 2.0f);
                ++i2;
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        NUp tool = new NUp();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

