/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controlpanel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

abstract class AbstractControls
implements ControllerListener {
    private final Player player;
    private final Hashtable<String, AbstractListenerControl> controlTable = new Hashtable();

    protected AbstractControls(Skin skin, Player player) {
        if (player.getState() < 300) {
            throw new NotRealizedError("Player must be realized");
        }
        this.player = player;
        this.makeControls(skin);
        this.setControlsPlayer(player);
        player.addControllerListener(this);
        this.setControlComponentState(player.getState());
    }

    protected void addControl(String string, AbstractListenerControl abstractListenerControl) {
        this.controlTable.put(string, abstractListenerControl);
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof StartEvent) {
            SwingUtilities.invokeLater(new ControllerEventThread(600));
        } else if (controllerEvent instanceof StopEvent || controllerEvent instanceof ControllerErrorEvent) {
            SwingUtilities.invokeLater(new ControllerEventThread(500));
        }
    }

    public AbstractListenerControl getControl(String string) {
        return this.controlTable.get(string);
    }

    public AbstractListenerControl[] getControls() {
        Vector<AbstractListenerControl> vector = new Vector<AbstractListenerControl>();
        Enumeration<AbstractListenerControl> enumeration = this.controlTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new AbstractListenerControl[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Player getPlayer() {
        return this.player;
    }

    protected abstract void makeControls(Skin var1);

    protected abstract void setControlComponentState(int var1);

    private void setControlsPlayer(Player player) {
        Player player2 = player;
        Enumeration<AbstractListenerControl> enumeration = this.controlTable.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setController(player2);
        }
    }

    class ControllerEventThread
    implements Runnable {
        private int state;

        public ControllerEventThread(int n) {
            this.state = n;
        }

        public void run() {
            AbstractControls.this.setControlComponentState(this.state);
        }
    }
}

