/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import javax.media.Format;

public class ContentDescriptor
extends Format {
    public static final String RAW = "raw";
    public static final String RAW_RTP = "raw.rtp";
    public static final String MIXED = "application.mixed-data";
    public static final String CONTENT_UNKNOWN = "UnknownContent";

    private static final boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static final boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    private static final boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static final String mimeTypeToPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == '.') {
                stringBuffer.append('.');
                continue;
            }
            if (ContentDescriptor.isAlpha(c) || ContentDescriptor.isNumeric(c)) {
                if (ContentDescriptor.isUpperAlpha(c)) {
                    stringBuffer.append(Character.toLowerCase(c));
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public ContentDescriptor(String string) {
        super(string);
        this.dataType = byteArray;
    }

    public String getContentType() {
        return super.getEncoding();
    }

    public String toString() {
        return this.getContentType();
    }
}

