/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;

public class DataForm
implements PacketExtension {
    private String type;
    private String title;
    private List<String> instructions = new ArrayList<String>();
    private ReportedData reportedData;
    private final List<Item> items = new ArrayList<Item>();
    private final List<FormField> fields = new ArrayList<FormField>();

    public DataForm(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getInstructions() {
        List<String> list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.instructions)).iterator();
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<FormField> getFields() {
        List<FormField> list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInstructions(List<String> instructions) {
        this.instructions = instructions;
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField field) {
        List<FormField> list = this.fields;
        synchronized (list) {
            this.fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String instruction) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" type=\"" + this.getType() + "\">");
        if (this.getTitle() != null) {
            buf.append("<title>").append(this.getTitle()).append("</title>");
        }
        Iterator<String> it = this.getInstructions();
        while (it.hasNext()) {
            buf.append("<instructions>").append((Object)it.next()).append("</instructions>");
        }
        if (this.getReportedData() != null) {
            buf.append(this.getReportedData().toXML());
        }
        Iterator<Object> i = this.getItems();
        while (i.hasNext()) {
            Item item = i.next();
            buf.append(item.toXML());
        }
        i = this.getFields();
        while (i.hasNext()) {
            FormField field = (FormField)i.next();
            buf.append(field.toXML());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public static class Item {
        private List<FormField> fields = new ArrayList<FormField>();

        public Item(List<FormField> fields) {
            this.fields = fields;
        }

        public Iterator<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item>");
            Iterator<FormField> i = this.getFields();
            while (i.hasNext()) {
                FormField field = i.next();
                buf.append(field.toXML());
            }
            buf.append("</item>");
            return buf.toString();
        }
    }

    public static class ReportedData {
        private List<FormField> fields = new ArrayList<FormField>();

        public ReportedData(List<FormField> fields) {
            this.fields = fields;
        }

        public Iterator<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields)).iterator();
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<reported>");
            Iterator<FormField> i = this.getFields();
            while (i.hasNext()) {
                FormField field = i.next();
                buf.append(field.toXML());
            }
            buf.append("</reported>");
            return buf.toString();
        }
    }
}

