/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.StreamInitiation;

public abstract class StreamNegotiator {
    public StreamInitiation createInitiationAccept(StreamInitiation streamInitiationOffer, String[] namespaces) {
        StreamInitiation response = new StreamInitiation();
        response.setTo(streamInitiationOffer.getFrom());
        response.setFrom(streamInitiationOffer.getTo());
        response.setType(IQ.Type.RESULT);
        response.setPacketID(streamInitiationOffer.getPacketID());
        DataForm form = new DataForm("submit");
        FormField field = new FormField("stream-method");
        for (String namespace : namespaces) {
            field.addValue(namespace);
        }
        form.addField(field);
        response.setFeatureNegotiationForm(form);
        return response;
    }

    public IQ createError(String from, String to, String packetID, XMPPError xmppError) {
        IQ iq = FileTransferNegotiator.createIQ(packetID, to, from, IQ.Type.ERROR);
        iq.setError(xmppError);
        return iq;
    }

    Packet initiateIncomingStream(Connection connection, StreamInitiation initiation) throws XMPPException {
        StreamInitiation response = this.createInitiationAccept(initiation, this.getNamespaces());
        PacketCollector collector = connection.createPacketCollector(this.getInitiationPacketFilter(initiation.getFrom(), initiation.getSessionID()));
        connection.sendPacket((Packet)response);
        Packet streamMethodInitiation = collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (streamMethodInitiation == null) {
            throw new XMPPException("No response from file transfer initiator");
        }
        return streamMethodInitiation;
    }

    public abstract PacketFilter getInitiationPacketFilter(String var1, String var2);

    abstract InputStream negotiateIncomingStream(Packet var1) throws XMPPException, InterruptedException;

    public abstract InputStream createIncomingStream(StreamInitiation var1) throws XMPPException, InterruptedException;

    public abstract OutputStream createOutgoingStream(String var1, String var2, String var3) throws XMPPException;

    public abstract String[] getNamespaces();

    public abstract void cleanup();
}

