/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObject;

public abstract class WhiteboardObjectJabberImpl
implements WhiteboardObject {
    private int thickness = 1;
    private String ID;
    private int color;

    public WhiteboardObjectJabberImpl() {
        this.setID(this.generateID());
    }

    public WhiteboardObjectJabberImpl(String id, int thickness, int color) {
        this.setID(id);
        this.setColor(color);
        this.setThickness(thickness);
    }

    protected String generateID() {
        return String.valueOf(System.currentTimeMillis()) + String.valueOf(super.hashCode());
    }

    public String getID() {
        return this.ID;
    }

    protected void setID(String ID) {
        this.ID = ID;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WhiteboardObject)) {
            return false;
        }
        return obj == this || ((WhiteboardObject)obj).getID().equals(this.getID());
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    private String hex(int i) {
        String h = Integer.toHexString(i);
        if (i < 10) {
            h = "0" + h;
        }
        return h.toUpperCase();
    }

    protected String colorToHex(int color) {
        return this.colorToHex(Color.getColor("", color));
    }

    protected String colorToHex(Color color) {
        return "#" + this.hex(color.getRed()) + this.hex(color.getGreen()) + this.hex(color.getBlue());
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public abstract String toXML();
}

