/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.NotConnectedException;
import cx.ath.matthew.unix.UnixSocket;
import java.io.IOException;
import java.io.InputStream;

public class USInputStream
extends InputStream {
    public static final int MSG_DONTWAIT = 64;
    private int sock;
    boolean closed = false;
    private byte[] onebuf = new byte[1];
    private UnixSocket us;
    private boolean blocking = true;
    private int flags = 0;
    private int timeout = 0;

    private native int native_recv(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws IOException;

    public USInputStream(int n, UnixSocket unixSocket) {
        this.sock = n;
        this.us = unixSocket;
    }

    public void close() throws IOException {
        this.closed = true;
        this.us.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = 0;
        while (0 >= n) {
            n = this.read(this.onebuf);
        }
        if (-1 == n) {
            return -1;
        }
        return 0 > this.onebuf[0] ? -this.onebuf[0] : this.onebuf[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new NotConnectedException();
        }
        int n3 = this.native_recv(this.sock, byArray, n, n2, this.flags, this.timeout);
        if (0 == n3) {
            return -1;
        }
        if (-1 == n3) {
            return 0;
        }
        return n3;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UnixSocket getSocket() {
        return this.us;
    }

    public void setBlocking(boolean bl) {
        this.flags = bl ? 0 : 64;
    }

    public void setSoTimeout(int n) {
        this.timeout = n;
    }
}

