/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.parser.RawParser;

public class RawStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw stream parser";

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                for (int i = 0; i < this.tracks.length; ++i) {
                    ((FrameTrack)this.tracks[i]).stop();
                }
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public String getName() {
        return NAME;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PushSourceStream)this.streams[i], 5);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PushDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        SourceStream[] sourceStreamArray = ((PushDataSource)dataSource).getStreams();
        if (sourceStreamArray == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (sourceStreamArray.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(sourceStreamArray)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = sourceStreamArray;
    }

    public void start() throws IOException {
        this.source.start();
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).start();
        }
    }

    public void stop() {
        try {
            this.source.stop();
            for (int i = 0; i < this.tracks.length; ++i) {
                ((FrameTrack)this.tracks[i]).stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PushSourceStream;
    }

    class FrameTrack
    implements Track,
    SourceTransferHandler {
        Demultiplexer parser;
        PushSourceStream pss;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);
        boolean stopped = true;

        public FrameTrack(Demultiplexer demultiplexer, PushSourceStream pushSourceStream, int n) {
            this.pss = pushSourceStream;
            pushSourceStream.setTransferHandler(this);
            this.bufferQ = new CircularBuffer(n);
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Buffer buffer2;
            Object object;
            Object object2 = this.stateReq;
            synchronized (object2) {
                if (this.stopped) {
                    buffer.setDiscard(true);
                    buffer.setFormat(this.format);
                    return;
                }
            }
            object2 = this.bufferQ;
            synchronized (object2) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        object = this.stateReq;
                        synchronized (object) {
                            if (this.stopped) {
                                buffer.setDiscard(true);
                                buffer.setFormat(this.format);
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                buffer2 = this.bufferQ.read();
                this.bufferQ.notifyAll();
            }
            object2 = (byte[])buffer2.getData();
            buffer2.setData(buffer.getData());
            buffer.setData(object2);
            buffer.setLength(buffer2.getLength());
            buffer.setFormat(this.format);
            buffer.setRtpTimeStamp(buffer2.getRtpTimeStamp());
            buffer.setHeaderExtension(buffer2.getHeaderExtension());
            buffer.setTimeStamp(-1L);
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        public void setEnabled(boolean bl) {
            if (bl) {
                this.pss.setTransferHandler(this);
            } else {
                this.pss.setTransferHandler(null);
            }
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = true;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushSourceStream pushSourceStream) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canWrite()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                buffer = this.bufferQ.getEmptyBuffer();
                this.bufferQ.notifyAll();
            }
            int n = pushSourceStream.getMinimumTransferSize();
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null || byArray.length < n) {
                byArray = new byte[n];
                buffer.setData(byArray);
            }
            try {
                int n2 = pushSourceStream.read(byArray, 0, n);
                buffer.setLength(n2);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
        }
    }
}

