/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MemberAttributeChange
implements DataSerializable {
    private String uuid;
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeChange() {
    }

    public MemberAttributeChange(String uuid, MemberAttributeOperationType operationType, String key, Object value) {
        this.uuid = uuid;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public String getUuid() {
        return this.uuid;
    }

    public MemberAttributeOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.uuid);
        out.writeUTF(this.key);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            IOUtil.writeAttributeValue(this.value, out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = in.readUTF();
        this.key = in.readUTF();
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = IOUtil.readAttributeValue(in);
        }
    }
}

