/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.impl.client.QueueRequest;
import com.hazelcast.queue.impl.operations.ContainsOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ContainsRequest
extends QueueRequest
implements RetryableRequest {
    Collection<Data> dataList;

    public ContainsRequest() {
    }

    public ContainsRequest(String name, Collection<Data> dataList) {
        super(name);
        this.dataList = dataList;
    }

    @Override
    protected Operation prepareOperation() {
        return new ContainsOperation(this.name, this.dataList);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            out.writeData(data);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = in.readData();
            this.dataList.add(data);
        }
    }

    @Override
    public String getMethodName() {
        if (this.dataList.size() == 1) {
            return "contains";
        }
        return "containsAll";
    }

    @Override
    public Object[] getParameters() {
        if (this.dataList.size() == 1) {
            return this.dataList.toArray();
        }
        return new Object[]{this.dataList};
    }
}

