/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.component;

import java.util.EventListener;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class Container {
    private Object _listeners;

    public synchronized void addEventListener(Listener listener) {
        this._listeners = LazyList.add(this._listeners, listener);
    }

    public synchronized void removeEventListener(Listener listener) {
        this._listeners = LazyList.remove(this._listeners, listener);
    }

    public synchronized void update(Object parent, Object oldChild, Object child, String relationship) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
        }
        if (child != null && !child.equals(oldChild)) {
            this.add(parent, child, relationship);
        }
    }

    public synchronized void update(Object parent, Object oldChild, Object child, String relationship, boolean addRemove) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
            if (addRemove) {
                this.removeBean(oldChild);
            }
        }
        if (child != null && !child.equals(oldChild)) {
            if (addRemove) {
                this.addBean(child);
            }
            this.add(parent, child, relationship);
        }
    }

    public synchronized void update(Object parent, Object[] oldChildren, Object[] children, String relationship) {
        this.update(parent, oldChildren, children, relationship, false);
    }

    public synchronized void update(Object parent, Object[] oldChildren, Object[] children, String relationship, boolean addRemove) {
        int i;
        Object[] newChildren = null;
        if (children != null) {
            newChildren = new Object[children.length];
            i = children.length;
            while (i-- > 0) {
                boolean new_child = true;
                if (oldChildren != null) {
                    int j = oldChildren.length;
                    while (j-- > 0) {
                        if (children[i] == null || !children[i].equals(oldChildren[j])) continue;
                        oldChildren[j] = null;
                        new_child = false;
                    }
                }
                if (!new_child) continue;
                newChildren[i] = children[i];
            }
        }
        if (oldChildren != null) {
            i = oldChildren.length;
            while (i-- > 0) {
                if (oldChildren[i] == null) continue;
                this.remove(parent, oldChildren[i], relationship);
                if (!addRemove) continue;
                this.removeBean(oldChildren[i]);
            }
        }
        if (newChildren != null) {
            for (i = 0; i < newChildren.length; ++i) {
                if (newChildren[i] == null) continue;
                if (addRemove) {
                    this.addBean(newChildren[i]);
                }
                this.add(parent, newChildren[i], relationship);
            }
        }
    }

    public void addBean(Object obj) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                Listener listener = (Listener)LazyList.get(this._listeners, i);
                listener.addBean(obj);
            }
        }
    }

    public void removeBean(Object obj) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).removeBean(obj);
            }
        }
    }

    private void add(Object parent, Object child, String relationship) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + parent + " + " + child + " as " + relationship);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(parent, child, relationship);
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).add(event);
            }
        }
    }

    private void remove(Object parent, Object child, String relationship) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + parent + " - " + child + " as " + relationship);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(parent, child, relationship);
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).remove(event);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void addBean(Object var1);

        public void removeBean(Object var1);

        public void add(Relationship var1);

        public void remove(Relationship var1);
    }

    public static class Relationship {
        private Object _parent;
        private Object _child;
        private String _relationship;

        private Relationship(Object parent, Object child, String relationship) {
            this._parent = parent;
            this._child = child;
            this._relationship = relationship;
        }

        public Object getChild() {
            return this._child;
        }

        public Object getParent() {
            return this._parent;
        }

        public String getRelationship() {
            return this._relationship;
        }

        public String toString() {
            return this._parent + "---" + this._relationship + "-->" + this._child;
        }
    }
}

