/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeAliasingMapper
extends MapperWrapper {
    private final Map aliasToName = new HashMap();
    private transient Map nameToAlias = new HashMap();

    public AttributeAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public void addAliasFor(String attributeName, String alias) {
        this.aliasToName.put(alias, attributeName);
        this.nameToAlias.put(attributeName, alias);
    }

    public String aliasForAttribute(String attribute) {
        String alias = (String)this.nameToAlias.get(attribute);
        return alias == null ? super.aliasForAttribute(attribute) : alias;
    }

    public String attributeForAlias(String alias) {
        String name = (String)this.aliasToName.get(alias);
        return name == null ? super.attributeForAlias(alias) : name;
    }

    private String getAliasForName(String name) {
        String alias = (String)this.nameToAlias.get(name);
        return alias == null ? name : alias;
    }

    private Object readResolve() {
        this.nameToAlias = new HashMap();
        Iterator iter = this.aliasToName.keySet().iterator();
        while (iter.hasNext()) {
            Object alias = iter.next();
            this.nameToAlias.put(this.aliasToName.get(alias), alias);
        }
        return this;
    }
}

