/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import java.io.IOException;
import java.security.Permission;

public class RecoverTransactionRequest
extends CallableClientRequest {
    private boolean commit;
    private SerializableXID sXid;

    public RecoverTransactionRequest() {
    }

    public RecoverTransactionRequest(SerializableXID sXid, boolean commit) {
        this.sXid = sXid;
        this.commit = commit;
    }

    public Object call() throws Exception {
        TransactionManagerServiceImpl service = (TransactionManagerServiceImpl)this.getService();
        service.recoverClientTransaction(this.sXid, this.commit);
        return null;
    }

    @Override
    @Deprecated
    public String getServiceName() {
        return "hz:core:txManagerService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeBoolean("c", this.commit);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.sXid.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.commit = reader.readBoolean("c");
        ObjectDataInput in = reader.getRawDataInput();
        this.sXid = new SerializableXID();
        this.sXid.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

