/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.nio.serialization.Data;

public class WanOriginatedDeleteOperation
extends BaseRemoveOperation {
    boolean success;

    public WanOriginatedDeleteOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public WanOriginatedDeleteOperation() {
    }

    @Override
    public void run() {
        this.success = this.recordStore.remove(this.dataKey) != null;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public void afterRun() {
        if (this.success) {
            this.mapService.getMapServiceContext().interceptAfterRemove(this.name, this.dataValue);
            this.mapService.getMapServiceContext().getMapEventPublisher().publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
            this.invalidateNearCaches();
            this.evict(false);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.success;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public String toString() {
        return "DeleteOperation{" + this.name + "}";
    }
}

