/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ConfirmAck
extends AcctCommand {
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_UNAVAILABLE = 3;
    public static final int RESULT_ALREADY_CONFIRMED = 30;
    private static final int TYPE_ERROR_URL = 4;
    private final int result;
    private final String errorUrl;

    protected ConfirmAck(SnacPacket snacPacket) {
        super(7);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.result = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.errorUrl = immutableTlvChain.getString(4);
    }

    public ConfirmAck(int n) {
        this(n, null);
    }

    public ConfirmAck(int n, String string) {
        super(7);
        DefensiveTools.checkRange(n, "result", 0);
        this.result = n;
        this.errorUrl = string;
    }

    public final int getResult() {
        return this.result;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.result);
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(outputStream);
        }
    }

    public String toString() {
        return "ConfirmAck with result " + this.result + " (url=" + this.errorUrl + ")";
    }
}

