/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.group.ConcurrentGroupList;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.cluster.RoomUpdatedEvent;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntity;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntity;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.MUCRoomUtils;
import org.jivesoftware.openfire.plugin.rest.utils.UserUtils;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.ClusterTask;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class MUCRoomController {
    public static final MUCRoomController INSTANCE = new MUCRoomController();

    public static MUCRoomController getInstance() {
        return INSTANCE;
    }

    public MUCRoomEntities getChatRooms(String serviceName, String channelType, String roomSearch, boolean expand) {
        List rooms = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRooms();
        ArrayList<MUCRoomEntity> mucRoomEntities = new ArrayList<MUCRoomEntity>();
        for (MUCRoom chatRoom : rooms) {
            if (roomSearch != null && !chatRoom.getName().contains(roomSearch)) continue;
            if (channelType.equals("all")) {
                mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom, expand));
                continue;
            }
            if (!channelType.equals("public") || !chatRoom.isPublicRoom()) continue;
            mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom, expand));
        }
        return new MUCRoomEntities(mucRoomEntities);
    }

    public MUCRoomEntity getChatRoom(String roomName, String serviceName, boolean expand) throws ServiceException {
        MUCRoom chatRoom = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName);
        if (chatRoom == null) {
            throw new ServiceException("Could not find the chat room", roomName, "RoomNotFoundException", Response.Status.NOT_FOUND);
        }
        MUCRoomEntity mucRoomEntity = this.convertToMUCRoomEntity(chatRoom, expand);
        return mucRoomEntity;
    }

    public void deleteChatRoom(String roomName, String serviceName) throws ServiceException {
        MUCRoom chatRoom = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        if (chatRoom == null) {
            throw new ServiceException("Could not remove the channel", roomName, "RoomNotFoundException", Response.Status.NOT_FOUND);
        }
        chatRoom.destroyRoom(null, null);
    }

    public void createChatRoom(String serviceName, MUCRoomEntity mucRoomEntity) throws ServiceException {
        try {
            this.createRoom(mucRoomEntity, serviceName);
        }
        catch (NotAllowedException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (AlreadyExistsException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "AlreadyExistsException", Response.Status.CONFLICT, e);
        }
    }

    public void updateChatRoom(String roomName, String serviceName, MUCRoomEntity mucRoomEntity) throws ServiceException {
        try {
            if (!roomName.equals(mucRoomEntity.getRoomName())) {
                throw new ServiceException("Could not update the channel. The room name is different to the entity room name.", roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
            }
            this.createRoom(mucRoomEntity, serviceName);
        }
        catch (NotAllowedException e) {
            throw new ServiceException("Could not update the channel", roomName, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not update the channel", roomName, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not update the channel", roomName, "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (AlreadyExistsException e) {
            throw new ServiceException("Could not update the channel", mucRoomEntity.getRoomName(), "AlreadyExistsException", Response.Status.CONFLICT, e);
        }
    }

    private void createRoom(MUCRoomEntity mucRoomEntity, String serviceName) throws NotAllowedException, ForbiddenException, ConflictException, AlreadyExistsException {
        JID owner = XMPPServer.getInstance().createJID("admin", null);
        if (mucRoomEntity.getOwners() != null && mucRoomEntity.getOwners().size() > 0) {
            owner = new JID(mucRoomEntity.getOwners().get(0));
        } else {
            ArrayList<String> owners = new ArrayList<String>();
            owners.add(owner.toBareJID());
            mucRoomEntity.setOwners(owners);
        }
        boolean serviceRegistered = XMPPServer.getInstance().getMultiUserChatManager().isServiceRegistered(serviceName);
        if (!serviceRegistered) {
            XMPPServer.getInstance().getMultiUserChatManager().createMultiUserChatService(serviceName, serviceName, Boolean.valueOf(false));
        }
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(mucRoomEntity.getRoomName().toLowerCase(), owner);
        room.setNaturalLanguageName(mucRoomEntity.getNaturalName());
        room.setSubject(mucRoomEntity.getSubject());
        room.setDescription(mucRoomEntity.getDescription());
        room.setPassword(mucRoomEntity.getPassword());
        room.setPersistent(mucRoomEntity.isPersistent());
        room.setPublicRoom(mucRoomEntity.isPublicRoom());
        room.setRegistrationEnabled(mucRoomEntity.isRegistrationEnabled());
        room.setCanAnyoneDiscoverJID(mucRoomEntity.isCanAnyoneDiscoverJID());
        room.setCanOccupantsChangeSubject(mucRoomEntity.isCanOccupantsChangeSubject());
        room.setCanOccupantsInvite(mucRoomEntity.isCanOccupantsInvite());
        room.setChangeNickname(mucRoomEntity.isCanChangeNickname());
        room.setModificationDate(mucRoomEntity.getModificationDate());
        room.setLogEnabled(mucRoomEntity.isLogEnabled());
        room.setLoginRestrictedToNickname(mucRoomEntity.isLoginRestrictedToNickname());
        room.setMaxUsers(mucRoomEntity.getMaxUsers());
        room.setMembersOnly(mucRoomEntity.isMembersOnly());
        room.setModerated(mucRoomEntity.isModerated());
        if (mucRoomEntity.getBroadcastPresenceRoles() != null) {
            room.setRolesToBroadcastPresence(mucRoomEntity.getBroadcastPresenceRoles());
        } else {
            room.setRolesToBroadcastPresence(new ArrayList());
        }
        this.setRoles(room, mucRoomEntity);
        if (mucRoomEntity.getCreationDate() != null) {
            room.setCreationDate(mucRoomEntity.getCreationDate());
        } else {
            room.setCreationDate(new Date());
        }
        if (mucRoomEntity.getModificationDate() != null) {
            room.setModificationDate(mucRoomEntity.getModificationDate());
        } else {
            room.setModificationDate(new Date());
        }
        room.unlock(room.getRole());
        if (ClusterManager.isClusteringStarted()) {
            CacheFactory.doClusterTask((ClusterTask)new RoomUpdatedEvent((LocalMUCRoom)room));
        }
        if (room.isPersistent()) {
            room.saveToDB();
        }
    }

    public ParticipantEntities getRoomParticipants(String roomName, String serviceName) {
        ParticipantEntities participantEntities = new ParticipantEntities();
        ArrayList<ParticipantEntity> participants = new ArrayList<ParticipantEntity>();
        Collection serverParticipants = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName).getParticipants();
        for (MUCRole role : serverParticipants) {
            ParticipantEntity participantEntity = new ParticipantEntity();
            participantEntity.setJid(role.getRoleAddress().toFullJID());
            participantEntity.setRole(role.getRole().name());
            participantEntity.setAffiliation(role.getAffiliation().name());
            participants.add(participantEntity);
        }
        participantEntities.setParticipants(participants);
        return participantEntities;
    }

    public OccupantEntities getRoomOccupants(String roomName, String serviceName) {
        OccupantEntities occupantEntities = new OccupantEntities();
        ArrayList<OccupantEntity> occupants = new ArrayList<OccupantEntity>();
        Collection serverOccupants = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName).getOccupants();
        for (MUCRole role : serverOccupants) {
            OccupantEntity occupantEntity = new OccupantEntity();
            occupantEntity.setJid(role.getRoleAddress().toFullJID());
            occupantEntity.setRole(role.getRole().name());
            occupantEntity.setAffiliation(role.getAffiliation().name());
            occupants.add(occupantEntity);
        }
        occupantEntities.setOccupants(occupants);
        return occupantEntities;
    }

    public MUCRoomEntity convertToMUCRoomEntity(MUCRoom room, boolean expand) {
        MUCRoomEntity mucRoomEntity = new MUCRoomEntity(room.getNaturalLanguageName(), room.getName(), room.getDescription());
        mucRoomEntity.setSubject(room.getSubject());
        mucRoomEntity.setCanAnyoneDiscoverJID(room.canAnyoneDiscoverJID());
        mucRoomEntity.setCanChangeNickname(room.canChangeNickname());
        mucRoomEntity.setCanOccupantsChangeSubject(room.canOccupantsChangeSubject());
        mucRoomEntity.setCanOccupantsInvite(room.canOccupantsInvite());
        mucRoomEntity.setPublicRoom(room.isPublicRoom());
        mucRoomEntity.setPassword(room.getPassword());
        mucRoomEntity.setPersistent(room.isPersistent());
        mucRoomEntity.setRegistrationEnabled(room.isRegistrationEnabled());
        mucRoomEntity.setLogEnabled(room.isLogEnabled());
        mucRoomEntity.setLoginRestrictedToNickname(room.isLoginRestrictedToNickname());
        mucRoomEntity.setMaxUsers(room.getMaxUsers());
        mucRoomEntity.setMembersOnly(room.isMembersOnly());
        mucRoomEntity.setModerated(room.isModerated());
        ConcurrentGroupList owners = new ConcurrentGroupList(room.getOwners());
        ConcurrentGroupList admins = new ConcurrentGroupList(room.getAdmins());
        ConcurrentGroupList members = new ConcurrentGroupList(room.getMembers());
        ConcurrentGroupList outcasts = new ConcurrentGroupList(room.getOutcasts());
        if (expand) {
            for (Group ownerGroup : owners.getGroups()) {
                owners.addAllAbsent(ownerGroup.getAll());
            }
            for (Group adminGroup : admins.getGroups()) {
                admins.addAllAbsent(adminGroup.getAll());
            }
            for (Group memberGroup : members.getGroups()) {
                members.addAllAbsent(memberGroup.getAll());
            }
            for (Group outcastGroup : outcasts.getGroups()) {
                outcasts.addAllAbsent(outcastGroup.getAll());
            }
        }
        mucRoomEntity.setOwners(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)owners));
        mucRoomEntity.setAdmins(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)admins));
        mucRoomEntity.setMembers(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)members));
        mucRoomEntity.setOutcasts(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)outcasts));
        mucRoomEntity.setOwnerGroups(MUCRoomUtils.convertGroupsToStringList(owners.getGroups()));
        mucRoomEntity.setAdminGroups(MUCRoomUtils.convertGroupsToStringList(admins.getGroups()));
        mucRoomEntity.setMemberGroups(MUCRoomUtils.convertGroupsToStringList(members.getGroups()));
        mucRoomEntity.setOutcastGroups(MUCRoomUtils.convertGroupsToStringList(outcasts.getGroups()));
        mucRoomEntity.setBroadcastPresenceRoles(room.getRolesToBroadcastPresence());
        mucRoomEntity.setCreationDate(room.getCreationDate());
        mucRoomEntity.setModificationDate(room.getModificationDate());
        return mucRoomEntity;
    }

    private void setRoles(MUCRoom room, MUCRoomEntity mucRoomEntity) throws ForbiddenException, NotAllowedException, ConflictException {
        ArrayList roles = new ArrayList();
        ArrayList owners = new ArrayList();
        ArrayList<JID> existingOwners = new ArrayList<JID>();
        List<JID> mucRoomEntityOwners = MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners());
        owners.addAll(room.getOwners());
        for (JID jid : owners) {
            if (!mucRoomEntityOwners.contains(jid)) continue;
            existingOwners.add(jid);
        }
        owners.removeAll(existingOwners);
        room.addOwners(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()), room.getRole());
        roles.addAll(owners);
        roles.addAll(room.getAdmins());
        roles.addAll(room.getMembers());
        roles.addAll(room.getOutcasts());
        for (JID jid : roles) {
            room.addNone(jid, room.getRole());
        }
        room.addOwners(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()), room.getRole());
        if (mucRoomEntity.getAdmins() != null) {
            room.addAdmins(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getAdmins()), room.getRole());
        }
        if (mucRoomEntity.getMembers() != null) {
            for (String memberJid : mucRoomEntity.getMembers()) {
                room.addMember(new JID(memberJid), null, room.getRole());
            }
        }
        if (mucRoomEntity.getOutcasts() != null) {
            for (String outcastJid : mucRoomEntity.getOutcasts()) {
                room.addOutcast(new JID(outcastJid), null, room.getRole());
            }
        }
    }

    public void addAdmin(String serviceName, String roomName, String jid) throws ServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addAdmin(UserUtils.checkAndGetJID(jid), room.getRole());
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not add admin", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not add admin", jid, "NotAllowedException", Response.Status.CONFLICT, e);
        }
    }

    public void addOwner(String serviceName, String roomName, String jid) throws ServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addOwner(UserUtils.checkAndGetJID(jid), room.getRole());
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not add owner", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
    }

    public void addMember(String serviceName, String roomName, String jid) throws ServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addMember(UserUtils.checkAndGetJID(jid), null, room.getRole());
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not add member", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not add member", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
    }

    public void addOutcast(String serviceName, String roomName, String jid) throws ServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addOutcast(UserUtils.checkAndGetJID(jid), null, room.getRole());
        }
        catch (NotAllowedException e) {
            throw new ServiceException("Could not add outcast", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not add outcast", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not add outcast", jid, "NotAllowedException", Response.Status.CONFLICT, e);
        }
    }

    public void deleteAffiliation(String serviceName, String roomName, String jid) throws ServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            JID userJid = UserUtils.checkAndGetJID(jid);
            List addNonePresence = room.addNone(userJid, room.getRole());
            for (Presence presence : addNonePresence) {
                room.send((Packet)presence);
            }
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not delete affiliation", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not delete affiliation", jid, "NotAllowedException", Response.Status.CONFLICT, e);
        }
    }
}

