/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.multiplexer.RawBufferMux;

public class RawSyncBufferMux
extends RawBufferMux {
    boolean mpegBFrame = false;
    boolean mpegPFrame = false;
    protected boolean monoIncrTime = false;
    private long monoStartTime = 0L;
    private long monoTime = 0L;
    private Object waitLock = new Object();
    private boolean resetted = false;
    private boolean masterTrackEnded = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static int THRESHOLD = 80;
    static int LEEWAY = 5;

    public RawSyncBufferMux() {
        this.timeBase = new RawBufferMux.RawMuxTimeBase();
        this.allowDrop = true;
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return "Raw Sync Buffer Multiplexer";
    }

    public boolean initializeTracks(Format[] formatArray) {
        if (!super.initializeTracks(formatArray)) {
            return false;
        }
        this.masterTrackID = 0;
        for (int i = 0; i < formatArray.length; ++i) {
            if (!(formatArray[i] instanceof AudioFormat)) continue;
            this.masterTrackID = i;
        }
        return true;
    }

    public int process(Buffer buffer, int n) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[n] != null && this.mc[n].isEnabled()) {
            this.mc[n].process(buffer);
        }
        if (this.streams == null || buffer == null || n >= this.streams.length) {
            return 1;
        }
        if (buffer.isDiscard()) {
            return 0;
        }
        if ((buffer.getFlags() & 0x40) == 0) {
            if (buffer.getFormat() instanceof AudioFormat) {
                if (mpegAudio.matches(buffer.getFormat())) {
                    this.waitForPT(buffer.getTimeStamp(), n);
                } else {
                    this.waitForPT(this.mediaTime[n], n);
                }
            } else if (buffer.getTimeStamp() >= 0L) {
                if (mpegVideo.matches(buffer.getFormat()) && (buffer.getFlags() & 0x800) != 0) {
                    int n2;
                    byte[] byArray = (byte[])buffer.getData();
                    int n3 = byArray[(n2 = buffer.getOffset()) + 2] & 7;
                    if (n3 > 2) {
                        this.mpegBFrame = true;
                    } else if (n3 == 2) {
                        this.mpegPFrame = true;
                    }
                    if (n3 > 2 || n3 == 2 && !this.mpegBFrame || n3 == 1 && !(this.mpegBFrame | this.mpegPFrame)) {
                        this.waitForPT(buffer.getTimeStamp(), n);
                    }
                } else {
                    this.waitForPT(buffer.getTimeStamp(), n);
                }
            }
        }
        this.updateTime(buffer, n);
        buffer.setFlags(buffer.getFlags() | 0x60);
        if ((!(buffer.getFormat() instanceof AudioFormat) || mpegAudio.matches(buffer.getFormat())) && this.monoIncrTime) {
            this.monoTime = this.monoStartTime + buffer.getTimeStamp() - this.mediaStartTime * 1000000L;
            buffer.setTimeStamp(this.monoTime);
        }
        if (buffer.isEOM() && n == this.masterTrackID) {
            this.masterTrackEnded = true;
        }
        buffer.setHeader(System.currentTimeMillis());
        return this.streams[n].process(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        super.reset();
        this.mpegBFrame = false;
        this.mpegPFrame = false;
        Object object = this.waitLock;
        synchronized (object) {
            this.resetted = true;
            this.waitLock.notify();
        }
    }

    public void setMediaTime(Time time) {
        super.setMediaTime(time);
        this.monoStartTime = this.monoTime + 10L;
    }

    public void syncStart(Time time) {
        this.masterTrackEnded = false;
        super.syncStart(time);
    }

    protected void updateTime(Buffer buffer, int n) {
        if (buffer.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buffer.getFormat())) {
                if (buffer.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[n] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[n] = buffer.getTimeStamp();
                }
            } else {
                long l = ((AudioFormat)buffer.getFormat()).computeDuration(buffer.getLength());
                if (l >= 0L) {
                    int n2 = n;
                    this.mediaTime[n2] = this.mediaTime[n2] + l;
                } else {
                    this.mediaTime[n] = buffer.getTimeStamp();
                }
            }
        } else {
            this.mediaTime[n] = buffer.getTimeStamp() < 0L && this.systemStartTime >= 0L ? (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L : buffer.getTimeStamp();
        }
        this.timeBase.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPT(long l, int n) {
        long l2 = this.masterTrackID == -1 || n == this.masterTrackID ? (this.systemStartTime < 0L ? 0L : l - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime)) : (l /= 1000000L) - this.mediaTime[this.masterTrackID] / 1000000L;
        if (l2 > 2000L) {
            return;
        }
        while (l2 > (long)LEEWAY && !this.masterTrackEnded) {
            if (l2 > (long)THRESHOLD) {
                l2 = THRESHOLD;
            }
            Object object = this.waitLock;
            synchronized (object) {
                try {
                    this.waitLock.wait(l2);
                }
                catch (Exception exception) {
                    break;
                }
                if (this.resetted) {
                    this.resetted = false;
                    break;
                }
            }
            if (this.masterTrackID == -1 || n == this.masterTrackID) {
                l2 = l - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime);
                continue;
            }
            l2 = l - this.mediaTime[this.masterTrackID] / 1000000L;
        }
    }
}

