/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jitsi.service.neomedia.AbstractActiveSpeakerDetector;

public class BasicActiveSpeakerDetector
extends AbstractActiveSpeakerDetector {
    private static final double ACTIVE_COEF = 1.15;
    private static final int MAX_NEW_ACTIVE_SILENT_INTERVAL = 1000;
    private static final double MIN_NEW_ACTIVE_SCORE = 120.0;
    private static final int MIN_NEW_ACTIVE_SIZE = 20;
    private History active;
    private final Object activeSyncRoot = new Object();
    private final Map<Long, History> histories = new HashMap<Long, History>();
    private final ReadWriteLock historiesLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private History getHistory(long ssrc) {
        History history = null;
        Lock readLock = this.historiesLock.readLock();
        readLock.lock();
        try {
            history = this.histories.get(ssrc);
        }
        finally {
            readLock.unlock();
        }
        if (history == null) {
            history = new History(ssrc);
            Lock writeLock = this.historiesLock.writeLock();
            writeLock.lock();
            try {
                this.histories.put(ssrc, history);
            }
            finally {
                writeLock.unlock();
            }
        }
        return history;
    }

    @Override
    public void levelChanged(long ssrc, int level) {
        History history = this.getHistory(ssrc);
        history.update(level);
        this.updateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private History setInitialActive(ArrayList<History> histories) {
        History bestHistory = null;
        Double bestScore = 0.0;
        for (History h : histories) {
            if (!(h.score >= bestScore)) continue;
            bestHistory = h;
            bestScore = h.score;
        }
        Object object = this.activeSyncRoot;
        synchronized (object) {
            this.active = bestHistory;
        }
        return bestHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActive() {
        ArrayList<History> histories;
        History active;
        Object object = this.activeSyncRoot;
        synchronized (object) {
            active = this.active;
        }
        Lock readLock = this.historiesLock.readLock();
        readLock.lock();
        try {
            histories = new ArrayList<History>(this.histories.values());
        }
        finally {
            readLock.unlock();
        }
        if (histories.isEmpty()) {
            return;
        }
        if (active == null) {
            active = this.setInitialActive(histories);
            if (active != null) {
                this.fireActiveSpeakerChanged(active.ssrc);
            }
            return;
        }
        History newActive = active;
        for (History history : histories) {
            if (history.lastUpdate != -1L && history.lastUpdate + 1000L < System.currentTimeMillis()) {
                history.reset();
            }
            if (!(history.score > active.score * 1.15) || !(history.score > newActive.score) || history.size < 20 || !(history.score >= 120.0)) continue;
            newActive = history;
        }
        if (newActive != active) {
            Object object2 = this.activeSyncRoot;
            synchronized (object2) {
                this.active = newActive;
            }
            this.fireActiveSpeakerChanged(newActive.ssrc);
        }
    }

    private static class History {
        private static final int C_OLDER = 1;
        private static final int C_RECENT = 2;
        private static final int SIZE = 125;
        private int head = 0;
        private int[] history = new int[125];
        private long lastUpdate = -1L;
        private double score = 0.0;
        private int size = 0;
        private long ssrc = -1L;

        private History(long ssrc) {
            this.ssrc = ssrc;
        }

        private synchronized void reset() {
            this.lastUpdate = -1L;
            this.head = 0;
            this.size = 0;
            this.score = 0.0;
            Arrays.fill(this.history, 0);
        }

        private synchronized void update(int level) {
            this.history[this.head] = level;
            this.head = (this.head + 1) % 125;
            this.size = Math.min(this.size + 1, 125);
            int sum = 0;
            for (int i = 0; i < 100; ++i) {
                sum += this.history[(this.head + i) % 125];
            }
            int sum2 = 0;
            for (int i = 0; i < 25; ++i) {
                sum2 += this.history[(125 + this.head - 1 - i) % 125];
            }
            this.score = 1.0 * (double)sum / 100.0 + 2.0 * (double)sum2 / 25.0;
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

