/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.IOException;
import java.io.OutputStream;

public class ByteBufferOutputStream
extends OutputStream {
    private final int beginIndex;
    private final byte[] buf;
    private final int endIndex;
    private int index;

    public ByteBufferOutputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteBufferOutputStream(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("off");
        }
        if (n2 > byArray.length) {
            throw new IndexOutOfBoundsException("len");
        }
        this.buf = byArray;
        this.beginIndex = n;
        this.index = n;
        this.endIndex = n + n2;
    }

    public int size() {
        return this.index - this.beginIndex;
    }

    public void write(int n) throws IOException {
        if (this.index >= this.endIndex) {
            throw new IOException("This " + ByteBufferOutputStream.class.getName() + " is fully written.");
        }
        this.buf[this.index++] = (byte)n;
    }
}

