/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacketSender;
import net.sf.fmj.media.rtp.util.UDPPacket;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTCPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;

    public RTCPRawSender(int n, String string) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(string);
        this.destport = n | 1;
        this.destAddressList = null;
    }

    public RTCPRawSender(int n, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(n, string);
        this.setConsumer(uDPPacketSender);
        this.destAddressList = null;
    }

    public RTCPRawSender(RTPPacketSender rTPPacketSender) {
        this.setConsumer(rTPPacketSender);
    }

    public void addDestAddr(InetAddress inetAddress) {
        InetAddress inetAddress2;
        int n = 0;
        if (this.destAddressList == null) {
            this.destAddressList = new Vector();
            this.destAddressList.addElement(this.destaddr);
        }
        for (n = 0; n < this.destAddressList.size() && !(inetAddress2 = (InetAddress)this.destAddressList.elementAt(n)).equals(inetAddress); ++n) {
        }
        if (n == this.destAddressList.size()) {
            this.destAddressList.addElement(inetAddress);
        }
    }

    public void assemble(RTCPCompoundPacket rTCPCompoundPacket) {
        int n = rTCPCompoundPacket.calcLength();
        rTCPCompoundPacket.assemble(n, false);
    }

    public String filtername() {
        return "RTCP Raw Packet Sender";
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public Packet handlePacket(Packet packet) {
        this.assemble((RTCPCompoundPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = this.destaddr;
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet, int n) {
        this.assemble((RTCPCompoundPacket)packet);
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = (InetAddress)this.destAddressList.elementAt(n);
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        this.assemble((RTCPCompoundPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = sessionAddress.getControlAddress();
        uDPPacket.remotePort = sessionAddress.getControlPort();
        return uDPPacket;
    }

    public void setDestAddresses(Vector vector) {
        this.destAddressList = vector;
    }
}

