/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.util.BufferToImage;

public class JpegEncoder
extends AbstractCodec
implements Codec {
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private final Format[] supportedOutputFormats = new Format[]{new JPEGFormat()};
    private BufferToImage bufferToImage;

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Format[] formatArray = new Format[]{new JPEGFormat(videoFormat.getSize(), -1, Format.byteArray, videoFormat.getFrameRate(), -1, -1)};
        return formatArray;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        BufferedImage bufferedImage = (BufferedImage)this.bufferToImage.createImage(buffer);
        try {
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(0.74f);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("JPEG").next();
            imageWriter.setOutput(memoryCacheImageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
            memoryCacheImageOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            buffer2.setData(byArray);
            buffer2.setOffset(0);
            buffer2.setLength(byArray.length);
            return 0;
        }
        catch (IOException iOException) {
            buffer2.setDiscard(true);
            buffer2.setLength(0);
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }
}

