/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YUVFormat
extends VideoFormat {
    public static final int YUV_411 = 1;
    public static final int YUV_420 = 2;
    public static final int YUV_422 = 4;
    public static final int YUV_111 = 8;
    public static final int YUV_YVU9 = 16;
    public static final int YUV_YUYV = 32;
    public static final int YUV_SIGNED = 64;
    protected int yuvType = -1;
    protected int strideY = -1;
    protected int strideUV = -1;
    protected int offsetY = -1;
    protected int offsetU = -1;
    protected int offsetV = -1;
    private static String ENCODING = "yuv";

    public YUVFormat() {
        super(ENCODING);
    }

    public YUVFormat(Dimension dimension, int n, Class<?> clazz, float f, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(ENCODING, dimension, n, clazz, f);
        this.yuvType = n2;
        this.strideY = n3;
        this.strideUV = n4;
        this.offsetY = n5;
        this.offsetU = n6;
        this.offsetV = n7;
    }

    public YUVFormat(int n) {
        super(ENCODING);
        this.yuvType = n;
    }

    @Override
    public Object clone() {
        YUVFormat yUVFormat = new YUVFormat(this.size, this.maxDataLength, this.dataType, this.frameRate, this.yuvType, this.strideY, this.strideUV, this.offsetY, this.offsetU, this.offsetV);
        yUVFormat.copy(this);
        return yUVFormat;
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        if (format instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)format;
            this.yuvType = yUVFormat.yuvType;
            this.strideY = yUVFormat.strideY;
            this.strideUV = yUVFormat.strideUV;
            this.offsetY = yUVFormat.offsetY;
            this.offsetU = yUVFormat.offsetU;
            this.offsetV = yUVFormat.offsetV;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)object;
            return super.equals(object) && this.yuvType == yUVFormat.yuvType && this.strideY == yUVFormat.strideY && this.strideUV == yUVFormat.strideUV && this.offsetY == yUVFormat.offsetY && this.offsetU == yUVFormat.offsetU && this.offsetV == yUVFormat.offsetV;
        }
        return false;
    }

    public int getOffsetU() {
        return this.offsetU;
    }

    public int getOffsetV() {
        return this.offsetV;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getStrideUV() {
        return this.strideUV;
    }

    public int getStrideY() {
        return this.strideY;
    }

    public int getYuvType() {
        return this.yuvType;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof YUVFormat)) {
            return format2;
        }
        YUVFormat yUVFormat = (YUVFormat)format;
        YUVFormat yUVFormat2 = (YUVFormat)format2;
        yUVFormat2.yuvType = this.yuvType != -1 ? this.yuvType : yUVFormat.yuvType;
        yUVFormat2.strideY = this.strideY != -1 ? this.strideY : yUVFormat.strideY;
        yUVFormat2.strideUV = this.strideUV != -1 ? this.strideUV : yUVFormat.strideUV;
        yUVFormat2.offsetY = this.offsetY != -1 ? this.offsetY : yUVFormat.offsetY;
        yUVFormat2.offsetU = this.offsetU != -1 ? this.offsetU : yUVFormat.offsetU;
        yUVFormat2.offsetV = this.offsetV != -1 ? this.offsetV : yUVFormat.offsetV;
        return yUVFormat2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof YUVFormat)) {
            return true;
        }
        YUVFormat yUVFormat = (YUVFormat)format;
        return !(this.yuvType != -1 && yUVFormat.yuvType != -1 && this.yuvType != yUVFormat.yuvType || this.strideY != -1 && yUVFormat.strideY != -1 && this.strideY != yUVFormat.strideY || this.strideUV != -1 && yUVFormat.strideUV != -1 && this.strideUV != yUVFormat.strideUV || this.offsetY != -1 && yUVFormat.offsetY != -1 && this.offsetY != yUVFormat.offsetY || this.offsetU != -1 && yUVFormat.offsetU != -1 && this.offsetU != yUVFormat.offsetU || this.offsetV != -1 && yUVFormat.offsetV != -1 && this.offsetV != yUVFormat.offsetV);
    }

    @Override
    public Format relax() {
        YUVFormat yUVFormat = (YUVFormat)super.relax();
        if (yUVFormat == null) {
            return null;
        }
        yUVFormat.strideY = -1;
        yUVFormat.strideUV = -1;
        yUVFormat.offsetY = -1;
        yUVFormat.offsetU = -1;
        yUVFormat.offsetV = -1;
        return yUVFormat;
    }

    @Override
    public String toString() {
        return "YUV Video Format: Size = " + this.size + " MaxDataLength = " + this.maxDataLength + " DataType = " + this.dataType + " yuvType = " + this.yuvType + " StrideY = " + this.strideY + " StrideUV = " + this.strideUV + " OffsetY = " + this.offsetY + " OffsetU = " + this.offsetU + " OffsetV = " + this.offsetV + "\n";
    }
}

