/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H263Format
extends VideoFormat {
    private static String ENCODING = "h263";
    protected int advancedPrediction = -1;
    protected int arithmeticCoding = -1;
    protected int errorCompensation = -1;
    protected int hrDB = -1;
    protected int pbFrames = -1;
    protected int unrestrictedVector = -1;

    public H263Format() {
        super(ENCODING);
        this.dataType = Format.byteArray;
    }

    public H263Format(Dimension dimension, int n, Class<?> clazz, float f, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(ENCODING, dimension, n, clazz, f);
        this.advancedPrediction = n2;
        this.arithmeticCoding = n3;
        this.errorCompensation = n4;
        this.hrDB = n5;
        this.pbFrames = n6;
        this.unrestrictedVector = n7;
    }

    @Override
    public Object clone() {
        return new H263Format(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.advancedPrediction, this.arithmeticCoding, this.errorCompensation, this.hrDB, this.pbFrames, this.unrestrictedVector);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        H263Format h263Format = (H263Format)format;
        this.advancedPrediction = h263Format.advancedPrediction;
        this.arithmeticCoding = h263Format.arithmeticCoding;
        this.errorCompensation = h263Format.errorCompensation;
        this.hrDB = h263Format.hrDB;
        this.pbFrames = h263Format.pbFrames;
        this.unrestrictedVector = h263Format.unrestrictedVector;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof H263Format)) {
            return false;
        }
        H263Format h263Format = (H263Format)object;
        return this.advancedPrediction == h263Format.advancedPrediction && this.arithmeticCoding == h263Format.arithmeticCoding && this.errorCompensation == h263Format.errorCompensation && this.hrDB == h263Format.hrDB && this.pbFrames == h263Format.pbFrames && this.unrestrictedVector == h263Format.unrestrictedVector;
    }

    public int getAdvancedPrediction() {
        return this.advancedPrediction;
    }

    public int getArithmeticCoding() {
        return this.arithmeticCoding;
    }

    public int getErrorCompensation() {
        return this.errorCompensation;
    }

    public int getHrDB() {
        return this.hrDB;
    }

    public int getPBFrames() {
        return this.pbFrames;
    }

    public int getUnrestrictedVector() {
        return this.unrestrictedVector;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof H263Format) {
            H263Format h263Format = (H263Format)format2;
            H263Format h263Format2 = (H263Format)format;
            if (this.getClass().isAssignableFrom(format.getClass())) {
                if (FormatUtils.specified(this.advancedPrediction)) {
                    h263Format.advancedPrediction = this.advancedPrediction;
                }
                if (FormatUtils.specified(this.arithmeticCoding)) {
                    h263Format.arithmeticCoding = this.arithmeticCoding;
                }
                if (FormatUtils.specified(this.errorCompensation)) {
                    h263Format.errorCompensation = this.errorCompensation;
                }
                if (FormatUtils.specified(this.hrDB)) {
                    h263Format.hrDB = this.hrDB;
                }
                if (FormatUtils.specified(this.pbFrames)) {
                    h263Format.pbFrames = this.pbFrames;
                }
                if (FormatUtils.specified(this.unrestrictedVector)) {
                    h263Format.unrestrictedVector = this.unrestrictedVector;
                }
            } else if (format.getClass().isAssignableFrom(this.getClass())) {
                if (!FormatUtils.specified(h263Format.advancedPrediction)) {
                    h263Format.advancedPrediction = h263Format2.advancedPrediction;
                }
                if (!FormatUtils.specified(h263Format.arithmeticCoding)) {
                    h263Format.arithmeticCoding = h263Format2.arithmeticCoding;
                }
                if (!FormatUtils.specified(h263Format.errorCompensation)) {
                    h263Format.errorCompensation = h263Format2.errorCompensation;
                }
                if (!FormatUtils.specified(h263Format.hrDB)) {
                    h263Format.hrDB = h263Format2.hrDB;
                }
                if (!FormatUtils.specified(h263Format.pbFrames)) {
                    h263Format.pbFrames = h263Format2.pbFrames;
                }
                if (!FormatUtils.specified(h263Format.unrestrictedVector)) {
                    h263Format.unrestrictedVector = h263Format2.unrestrictedVector;
                }
            }
        }
        FormatTraceUtils.traceIntersects(this, format, format2);
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof H263Format)) {
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        H263Format h263Format = (H263Format)format;
        boolean bl = FormatUtils.matches(this.advancedPrediction, h263Format.advancedPrediction) && FormatUtils.matches(this.arithmeticCoding, h263Format.arithmeticCoding) && FormatUtils.matches(this.errorCompensation, h263Format.errorCompensation) && FormatUtils.matches(this.hrDB, h263Format.hrDB) && FormatUtils.matches(this.pbFrames, h263Format.pbFrames) && FormatUtils.matches(this.unrestrictedVector, h263Format.unrestrictedVector);
        FormatTraceUtils.traceMatches(this, format, bl);
        return bl;
    }

    @Override
    public String toString() {
        return "H.263 video format";
    }
}

