/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.LogRecord;

class MessageLog
implements LogRecord {
    private String message;
    private String source;
    private String destination;
    private long timeStamp;
    private boolean isSender;
    private String firstLine;
    private String tid;
    private String callId;
    private long timeStampHeaderValue;

    public boolean equals(Object object) {
        if (!(object instanceof MessageLog)) {
            return false;
        }
        MessageLog messageLog = (MessageLog)object;
        return messageLog.message.equals(this.message) && messageLog.timeStamp == this.timeStamp;
    }

    public MessageLog(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, long l) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = string;
        this.source = string2;
        this.destination = string3;
        try {
            long l2 = Long.parseLong(string4);
            if (l2 < 0L) {
                throw new IllegalArgumentException("Bad time stamp ");
            }
            this.timeStamp = l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format " + string4);
        }
        this.isSender = bl;
        this.firstLine = string5;
        this.tid = string6;
        this.callId = string7;
        this.timeStampHeaderValue = l;
    }

    public MessageLog(String string, String string2, String string3, long l, boolean bl, String string4, String string5, String string6, long l2) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = string;
        this.source = string2;
        this.destination = string3;
        if (l < 0L) {
            throw new IllegalArgumentException("negative ts");
        }
        this.timeStamp = l;
        this.isSender = bl;
        this.firstLine = string4;
        this.tid = string5;
        this.callId = string6;
        this.timeStampHeaderValue = l2;
    }

    public String toString() {
        String string = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\"" + (this.timeStampHeaderValue != 0L ? "\ntimeStamp = \"" + this.timeStampHeaderValue + "\"" : "") + "\nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\"" + " \n>\n";
        string = string + "<![CDATA[";
        string = string + this.message;
        string = string + "]]>\n";
        string = string + "</message>\n";
        return string;
    }
}

