/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.NotifiableEventListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;

public class CacheAddInvalidationListenerTask
extends AbstractCallableMessageTask<CacheAddInvalidationListenerCodec.RequestParameters> {
    public CacheAddInvalidationListenerTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ClientEndpoint endpoint = this.getEndpoint();
        CacheService cacheService = (CacheService)this.getService("hz:impl:cacheService");
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name);
        String registrationId = cacheService.addInvalidationListener(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, new CacheInvalidationEventListener(endpoint, cacheContext));
        endpoint.setListenerRegistration("hz:impl:cacheService", ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected CacheAddInvalidationListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddInvalidationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddInvalidationListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private final class CacheInvalidationEventListener
    implements CacheEventListener,
    NotifiableEventListener<CacheService> {
        private final ClientEndpoint endpoint;
        private final CacheContext cacheContext;

        private CacheInvalidationEventListener(ClientEndpoint endpoint, CacheContext cacheContext) {
            this.endpoint = endpoint;
            this.cacheContext = cacheContext;
        }

        @Override
        public void handleEvent(Object eventObject) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            if (eventObject instanceof CacheInvalidationMessage) {
                String targetUuid = this.endpoint.getUuid();
                if (eventObject instanceof CacheSingleInvalidationMessage) {
                    CacheSingleInvalidationMessage message = (CacheSingleInvalidationMessage)eventObject;
                    if (!targetUuid.equals(message.getSourceUuid())) {
                        ClientMessage eventMessage = CacheAddInvalidationListenerCodec.encodeCacheInvalidationEvent(message.getName(), message.getKey(), null);
                        CacheAddInvalidationListenerTask.this.sendClientMessage(message.getName(), eventMessage);
                    }
                } else if (eventObject instanceof CacheBatchInvalidationMessage) {
                    CacheBatchInvalidationMessage message = (CacheBatchInvalidationMessage)eventObject;
                    List<CacheSingleInvalidationMessage> invalidationMessages = message.getInvalidationMessages();
                    ArrayList<Data> filteredKeys = new ArrayList<Data>(invalidationMessages.size());
                    for (CacheSingleInvalidationMessage invalidationMessage : invalidationMessages) {
                        if (targetUuid.equals(invalidationMessage.getSourceUuid())) continue;
                        filteredKeys.add(invalidationMessage.getKey());
                    }
                    ClientMessage eventMessage = CacheAddInvalidationListenerCodec.encodeCacheBatchInvalidationEvent(message.getName(), filteredKeys, null);
                    CacheAddInvalidationListenerTask.this.sendClientMessage(message.getName(), eventMessage);
                }
            }
        }

        @Override
        public void onRegister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.increaseInvalidationListenerCount();
        }

        @Override
        public void onDeregister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.decreaseInvalidationListenerCount();
        }
    }
}

