/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import org.jrobin.core.Util;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class ValueAxisMrtg
implements RrdGraphConstants {
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxisMrtg(RrdGraph rrdGraph) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
        this.im.unit = this.gdef.unit;
    }

    boolean draw() {
        Font font = this.gdef.smallFont;
        Paint paint = this.gdef.colors[5];
        Paint paint2 = this.gdef.colors[6];
        int n = (int)(this.worker.getFontAscent(font) / 2.0);
        if (Double.isNaN((this.im.maxval - this.im.minval) / this.im.magfact)) {
            return false;
        }
        int n2 = this.im.xorigin;
        int n3 = this.im.xorigin + this.im.xsize;
        String string = this.im.scaledstep / this.im.magfact * (double)Math.max(Math.abs(this.im.quadrant), Math.abs(4 - this.im.quadrant)) <= 1.0 ? "%5.2f" : Util.sprintf("%%4.%df", 1 - (this.im.scaledstep / this.im.magfact > 10.0 || Math.ceil(this.im.scaledstep / this.im.magfact) == this.im.scaledstep / this.im.magfact ? 1 : 0));
        if (this.im.symbol != ' ' || this.im.unit != null) {
            string = string + " ";
        }
        if (this.im.symbol != ' ') {
            string = string + this.im.symbol;
        }
        if (this.im.unit != null) {
            string = string + this.im.unit;
        }
        for (int i = 0; i <= 4; ++i) {
            int n4 = this.im.yorigin - this.im.ysize * i / 4;
            if (n4 < this.im.yorigin - this.im.ysize || n4 > this.im.yorigin) continue;
            String string2 = Util.sprintf(string, this.im.scaledstep / this.im.magfact * (double)(i - this.im.quadrant));
            int n5 = (int)this.worker.getStringWidth(string2, font);
            this.worker.drawString(string2, n2 - n5 - 7, n4 + n, font, paint2);
            this.worker.drawLine(n2 - 2, n4, n2 + 2, n4, paint, TICK_STROKE);
            this.worker.drawLine(n3 - 2, n4, n3 + 2, n4, paint, TICK_STROKE);
            this.worker.drawLine(n2, n4, n3, n4, paint, GRID_STROKE);
        }
        return true;
    }
}

