/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.IcqSnacCommand;
import net.kano.joscar.snaccmd.icq.IcqType;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractIcqCmd
extends IcqSnacCommand {
    public static final IcqType CMD_OFFLINE_MSG_REQ = new IcqType(60);
    public static final IcqType CMD_OFFLINE_MSG_ACK = new IcqType(62);
    public static final IcqType CMD_OFFLINE_MSG = new IcqType(65);
    public static final IcqType CMD_OFFLINE_MSG_DONE = new IcqType(66);
    public static final IcqType CMD_META_FULL_INFO_REQ = new IcqType(2000, 1202);
    public static final IcqType CMD_META_SHORT_INFO_REQ = new IcqType(2000, 1210);
    public static final IcqType CMD_META_BASIC_INFO_CMD = new IcqType(2010, 200);
    public static final IcqType CMD_META_WORK_INFO_CMD = new IcqType(2010, 210);
    public static final IcqType CMD_META_MORE_INFO_CMD = new IcqType(2010, 220);
    public static final IcqType CMD_META_NOTES_INFO_CMD = new IcqType(2010, 230);
    public static final IcqType CMD_META_EMAIL_INFO_CMD = new IcqType(2010, 235);
    public static final IcqType CMD_META_INTERESTS_INFO_CMD = new IcqType(2010, 240);
    public static final IcqType CMD_META_AFFILIATIONS_INFO_CMD = new IcqType(2010, 250);
    public static final IcqType CMD_META_SHORT_INFO_CMD = new IcqType(2010, 260);
    public static final IcqType CMD_META_HOMEPAGE_CATEGORY_INFO_CMD = new IcqType(2010, 270);
    public static final IcqType CMD_META_SET_ACK = new IcqType(2010, 3135);
    public static final IcqType CMD_META_SET_CMD = new IcqType(2000, 3130);
    public static final IcqType CMD_META_SECURITY_CMD = new IcqType(2000, 1060);
    public static final IcqType CMD_META_SECURITY_ACK = new IcqType(2010, 160);
    private static final int TYPE_ICQ_DATA = 1;
    private long icqUIN;
    private IcqType icqType;
    private int icqID;
    private ByteBlock icqData;

    protected AbstractIcqCmd(int command, SnacPacket packet) {
        super(21, command);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock tlvBlock = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.processIcqTlvs(chain);
    }

    protected AbstractIcqCmd(int command, long uin, IcqType type, int id) {
        super(21, command);
        DefensiveTools.checkNull((Object)type, (String)"type");
        this.icqUIN = uin;
        this.icqType = type;
        this.icqID = id;
        this.icqData = null;
    }

    public final long getUIN() {
        return this.icqUIN;
    }

    public final IcqType getType() {
        return this.icqType;
    }

    public final int getId() {
        return this.icqID;
    }

    private void processIcqTlvs(TlvChain chain) {
        DefensiveTools.checkNull((Object)chain, (String)"chain");
        Tlv icqDataTlv = chain.getLastTlv(1);
        if (icqDataTlv == null) {
            this.icqUIN = -1L;
            this.icqType = null;
            this.icqID = -1;
        } else {
            ByteBlock icqBlock = icqDataTlv.getData();
            this.icqUIN = LEBinaryTools.getUInt(icqBlock, 2);
            this.icqID = LEBinaryTools.getUShort(icqBlock, 8);
            int hdrlen = 8;
            int primary = LEBinaryTools.getUShort(icqBlock, 6);
            if (-1 == primary) {
                this.icqType = null;
            } else if (primary < 1000) {
                this.icqType = new IcqType(primary);
            } else {
                int secondary = LEBinaryTools.getUShort(icqBlock, 10);
                this.icqType = -1 == secondary ? null : new IcqType(primary, secondary);
                hdrlen = 10;
            }
            this.icqData = icqBlock.getLength() >= hdrlen + 2 ? icqBlock.subBlock(hdrlen + 2) : null;
        }
    }

    public final ByteBlock getIcqData() {
        return this.icqData;
    }

    public final void writeData(OutputStream out) throws IOException {
        int secondary;
        ByteArrayOutputStream icqDataOut = new ByteArrayOutputStream();
        this.writeIcqData(icqDataOut);
        int hdrlen = 8;
        int primary = null != this.icqType ? this.icqType.getPrimary() : 0;
        int n = secondary = null != this.icqType ? this.icqType.getSecondary() : 0;
        if (0 != secondary) {
            hdrlen = 10;
        }
        ByteArrayOutputStream icqout = new ByteArrayOutputStream();
        int length = hdrlen + icqDataOut.size();
        LEBinaryTools.writeUShort(icqout, length);
        LEBinaryTools.writeUInt(icqout, this.icqUIN);
        LEBinaryTools.writeUShort(icqout, primary);
        LEBinaryTools.writeUShort(icqout, this.icqID);
        if (0 != secondary) {
            LEBinaryTools.writeUShort(icqout, secondary);
        }
        icqDataOut.writeTo(icqout);
        new Tlv(1, (Writable)ByteBlock.wrap((byte[])icqout.toByteArray())).write(out);
    }

    public abstract void writeIcqData(OutputStream var1) throws IOException;

    public String toString() {
        return "AbstractIcqCmd: type=" + this.icqType + ", uin=" + this.icqUIN + ", id=" + this.icqID + ", on top of " + super.toString();
    }

    protected static IcqType readIcqType(SnacPacket packet) {
        ByteBlock tlvBlock = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        Tlv icqDataTlv = chain.getLastTlv(1);
        if (icqDataTlv == null) {
            return null;
        }
        ByteBlock icqBlock = icqDataTlv.getData();
        int primary = LEBinaryTools.getUShort(icqBlock, 6);
        if (-1 == primary) {
            return null;
        }
        if (primary < 1000) {
            return new IcqType(primary);
        }
        int secondary = LEBinaryTools.getUShort(icqBlock, 10);
        return -1 == secondary ? null : new IcqType(primary, secondary);
    }
}

