/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.GroupChat;
import pl.mn.communicator.IGroupChat;
import pl.mn.communicator.IIncommingMessage;
import pl.mn.communicator.IMessageService;
import pl.mn.communicator.IOutgoingMessage;
import pl.mn.communicator.ISingleChat;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.SingleChat;
import pl.mn.communicator.event.MessageListener;
import pl.mn.communicator.packet.out.GGSendMsg;

public class DefaultMessageService
implements IMessageService {
    private Session m_session = null;
    private Set m_messageListeners = new HashSet();

    DefaultMessageService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
    }

    public void sendMessage(IOutgoingMessage outgoingMessage) throws GGException {
        if (outgoingMessage == null) {
            throw new NullPointerException("outgoingMessage cannot be null");
        }
        this.checkSessionState();
        try {
            GGSendMsg messageOut = new GGSendMsg(outgoingMessage);
            int[] additionalRecipients = outgoingMessage.getAdditionalRecipients();
            for (int i = 0; i < additionalRecipients.length; ++i) {
                int uin = additionalRecipients[i];
                messageOut.addAdditionalRecipient(uin);
            }
            this.m_session.getSessionAccessor().sendPackage(messageOut);
            this.notifyMessageSent(outgoingMessage);
        }
        catch (IOException ex) {
            throw new GGException("Error occured while sending message: " + outgoingMessage, ex);
        }
    }

    public ISingleChat createSingleChat(int uin) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        return new SingleChat(this.m_session, uin);
    }

    public IGroupChat createGroupChat() {
        return new GroupChat(this.m_session, new int[0]);
    }

    public IGroupChat createGroupChat(int[] uins) {
        if (uins == null) {
            throw new NullPointerException("uins cannot be null");
        }
        return new GroupChat(this.m_session, uins);
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener cannot be null");
        }
        this.m_messageListeners.add(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener cannot be null");
        }
        this.m_messageListeners.remove(messageListener);
    }

    protected void notifyMessageSent(IOutgoingMessage outgoingMessage) {
        if (outgoingMessage == null) {
            throw new NullPointerException("outgoingMessage cannot be null");
        }
        Iterator it = this.m_messageListeners.iterator();
        while (it.hasNext()) {
            MessageListener messageListener = (MessageListener)it.next();
            messageListener.messageSent(outgoingMessage);
        }
    }

    protected void notifyMessageArrived(IIncommingMessage incommingMessage) {
        if (incommingMessage == null) {
            throw new NullPointerException("incommingMessage cannot be null");
        }
        Iterator it = this.m_messageListeners.iterator();
        while (it.hasNext()) {
            MessageListener messageListener = (MessageListener)it.next();
            messageListener.messageArrived(incommingMessage);
        }
    }

    protected void notifyMessageDelivered(int uin, int messageID, MessageStatus messageStatus) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (messageID < 0) {
            throw new IllegalArgumentException("messageID cannot be less than 0");
        }
        if (messageStatus == null) {
            throw new NullPointerException("messageStatus cannot be less than 0");
        }
        Iterator it = this.m_messageListeners.iterator();
        while (it.hasNext()) {
            MessageListener messageListener = (MessageListener)it.next();
            messageListener.messageDelivered(uin, messageID, messageStatus);
        }
    }

    private void checkSessionState() throws GGSessionException {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
    }
}

