/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiscTools {
    private MiscTools() {
    }

    public static String getClassName(Object obj) {
        return MiscTools.getClassName(obj.getClass());
    }

    public static String getClassName(Class<?> cl) {
        return MiscTools.getClassName(cl.getName());
    }

    public static String getClassName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    @Nullable
    public static String findIntField(Class<?> cl, long value, String pattern) {
        Pattern p = pattern == null ? null : Pattern.compile(pattern);
        for (Field field : cl.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            String fieldName = field.getName();
            if (p != null && !p.matcher(fieldName).matches()) continue;
            try {
                if (field.getLong(null) != value) continue;
                return fieldName;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String findEqualField(Class<?> cl, Object value, String pattern) {
        Pattern p = pattern == null ? null : Pattern.compile(pattern);
        for (Field field : cl.getFields()) {
            Object fieldValue;
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            String fieldName = field.getName();
            if (p != null && !p.matcher(fieldName).matches()) continue;
            try {
                fieldValue = field.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (!(fieldValue == null ? value == null : fieldValue.equals(value))) continue;
            return fieldName;
        }
        return null;
    }

    public static Collection<String> findFlagFields(Class<?> cl, long value, String p) {
        Field[] fields = cl.getFields();
        TreeMap matches = new TreeMap(Collections.reverseOrder());
        Pattern pattern = p == null ? null : Pattern.compile(p);
        for (Field field : fields) {
            long fieldValue;
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            String fieldName = field.getName();
            if (pattern != null && !pattern.matcher(fieldName).matches()) continue;
            try {
                fieldValue = field.getLong(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if ((value & fieldValue) != fieldValue) continue;
            matches.put(fieldValue, fieldName);
        }
        Collection values = matches.values();
        return Collections.unmodifiableCollection(values);
    }

    public static String getFlagFieldsString(Class<?> cl, long value, String pattern) {
        Collection<String> fields = MiscTools.findFlagFields(cl, value, pattern);
        StringBuffer b = new StringBuffer();
        long covered = 0L;
        boolean first = true;
        for (String field : fields) {
            long fieldValue = 0L;
            try {
                fieldValue = cl.getField(field).getLong(null);
            }
            catch (NoSuchFieldException ignored) {
            }
            catch (SecurityException ignoredToo) {
            }
            catch (IllegalAccessException ignoredThree) {
                // empty catch block
            }
            if ((covered | fieldValue) == covered) continue;
            covered |= fieldValue;
            if (first) {
                first = false;
            } else {
                b.append(" | ");
            }
            b.append(field);
        }
        if (covered != 0L && (value & (covered ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            b.append(" | 0x");
            b.append(Long.toHexString(value & (covered ^ 0xFFFFFFFFFFFFFFFFL)));
        }
        return b.toString();
    }
}

