/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import net.sf.jqql.net.AbstractProxy;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.packets.PacketParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpProxy
extends AbstractProxy {
    private static final Log log = LogFactory.getLog(HttpProxy.class);
    public static final String SUCCESS = "200";
    public static final String NEED_AUTH = "407";
    public static final int STATUS_NONE = 0;
    public static final int STATUS_INIT = 1;
    public static final int STATUS_AUTH = 2;
    public static final int STATUS_READY = 3;
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] CONNECT_BEGIN = "CONNECT ".getBytes();
    private static final byte[] CONNECT_END = " HTTP/1.1\r\n".getBytes();
    private static final byte[] ACCEPT = "Accept: */*\r\n".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type: text/html\r\n".getBytes();
    private static final byte[] PROXY_CONNECTION = "Proxy-Connection: Keep-Alive\r\n".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-length: 0\r\n".getBytes();
    private static final byte[] PROXY_AUTHORIZATION = "Proxy-Authorization: Basic ".getBytes();
    private static byte[] authParam;
    protected byte[] remoteAddress;

    public HttpProxy(IProxyHandler iProxyHandler) throws IOException {
        super(iProxyHandler);
        this.status = 0;
    }

    public HttpProxy(IProxyHandler iProxyHandler, String string, String string2) throws IOException {
        this(iProxyHandler);
        this.username = string;
        this.password = string2;
        if (string == null || "".equals(string.trim()) || string2 == null) {
            authParam = null;
        } else {
            Base64 base64 = new Base64();
            authParam = new String(base64.encode((string + ":" + string2).getBytes())).getBytes();
        }
    }

    public void init() {
        log.trace((Object)"HttpProxy init");
        this.buffer.clear();
        this.buffer.put(CONNECT_BEGIN).put(this.remoteAddress).put(CONNECT_END).put(ACCEPT).put(CONTENT_TYPE).put(PROXY_CONNECTION).put(CONTENT_LENGTH).put(CRLF);
        this.buffer.flip();
        this.send();
        this.status = 1;
    }

    private void auth() {
        log.trace((Object)"HttpProxy auth");
        this.buffer.clear();
        this.buffer.put(CONNECT_BEGIN).put(this.remoteAddress).put(CONNECT_END).put(PROXY_AUTHORIZATION).put(authParam).put(CRLF).put(ACCEPT).put(CONTENT_TYPE).put(PROXY_CONNECTION).put(CONTENT_LENGTH).put(CRLF);
        this.buffer.flip();
        this.send();
        this.status = 2;
    }

    public void processRead(SelectionKey selectionKey) throws IOException, PacketParseException {
        log.trace((Object)"HttpProxy NIOHandler processRead");
        this.receive();
        byte[] byArray = new byte[this.buffer.limit()];
        this.buffer.get(byArray);
        String string = new String(byArray);
        log.debug((Object)string);
        if (!string.startsWith("HTTP/1.")) {
            return;
        }
        String string2 = string.substring(9, 12);
        switch (this.status) {
            case 1: {
                if (SUCCESS.equals(string2)) {
                    log.debug((Object)"\u8fde\u63a5\u6210\u529f");
                    this.status = 3;
                    this.handler.proxyReady(null);
                    break;
                }
                if (NEED_AUTH.equals(string2)) {
                    log.debug((Object)"\u9700\u8981\u9a8c\u8bc1\uff0c\u4f46\u662f\u672a\u63d0\u4f9b\u7528\u6237\u540d\u5bc6\u7801");
                    this.handler.proxyError("Proxy Need Auth");
                    break;
                }
                log.debug((Object)"\u672a\u77e5\u7684\u56de\u590d\u7801");
                this.handler.proxyError("Unknown Reply Code");
                break;
            }
            case 2: {
                if (SUCCESS.equals(string2)) {
                    log.debug((Object)"\u8fde\u63a5\u6210\u529f");
                    this.status = 3;
                    this.handler.proxyReady(null);
                    break;
                }
                if (NEED_AUTH.equals(string2)) {
                    log.debug((Object)"\u9a8c\u8bc1\u51fa\u9519\uff0c\u53ef\u80fd\u7528\u6237\u540d\u548c\u5bc6\u7801\u9519\u8bef");
                    this.handler.proxyAuthFail();
                    break;
                }
                log.debug((Object)"\u672a\u77e5\u7684\u56de\u590d\u7801");
                this.handler.proxyError("Unknown Reply Code");
                break;
            }
        }
    }

    public void processWrite() throws IOException {
        log.trace((Object)"HttpProxy processWrite");
        if (this.connected) {
            if (authParam == null) {
                this.init();
            } else {
                this.auth();
            }
        }
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        super.setRemoteAddress(inetSocketAddress);
        String string = inetSocketAddress.getHostName() + ':' + 443;
        this.remoteAddress = string.getBytes();
    }
}

