/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.networking.nio.ChannelInboundHandlerWithCounters;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.spi.impl.PacketHandler;
import java.nio.ByteBuffer;

public class MemberChannelInboundHandler
extends ChannelInboundHandlerWithCounters {
    protected final TcpIpConnection connection;
    protected Packet packet;
    private final PacketHandler handler;

    public MemberChannelInboundHandler(TcpIpConnection connection, PacketHandler handler) {
        this.connection = connection;
        this.handler = handler;
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        while (src.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = new Packet();
            }
            if (!(complete = this.packet.readFrom(src))) break;
            this.handlePacket(this.packet);
            this.packet = null;
        }
    }

    protected void handlePacket(Packet packet) throws Exception {
        if (packet.isFlagRaised(16)) {
            this.priorityPacketsRead.inc();
        } else {
            this.normalPacketsRead.inc();
        }
        packet.setConn(this.connection);
        this.handler.handle(packet);
    }
}

